/* Configures the DIO port of a E board with r/w mask 0x0F (bits 8..5=read &
bits 4..0 write). The write mask is set to 0x03 (so only bits 1..0 are
written).
Then the program altrenatively outputs 0x00 and 0xFF on the port and reads
the port to see some response:
Bits 8..5 reads the state of the corresponding DIO pins (1 if unconnected)
Bits 4..0 reads the echo of the written value.
These value are displayed.
 
usage: ./testdioe <device>
sample: ./testdioe /dev/nidio0 

*/

#include <fcntl.h>
#include <sys/ioctl.h>
#include <asm/ioctl.h>
#include <asm/types.h>
#include <stdio.h>
#include <unistd.h>

#include "nicts.h"

int main(int argc, char *argv[])
{
  int dio;
  unsigned char valout=0, valin=0;  
  
  if(argc<2){printf("usage !\n"); return 1;}

  if((dio=open(argv[1],O_RDWR))<0){
    perror("cant open that file"); exit(1);}

  if(ioctl(dio, NICTL_DIO_SELPORT, 0)<0){
    perror("cant ioctl selport"); exit(2);}
  if(ioctl(dio, NICTL_DIO_CONFPORT, 0x0F)<0){
    perror("cant ioctl confport"); exit(2);}
  
  ioctl(dio, NICTL_DIO_WRMASK, 0x03);
  
  while(1){
    if(write(dio,&valout,1)<1){
      perror("cant write nidio"); exit(2);}
    if(read(dio,&valin,1)<1){
      perror("cant read nidio"); exit(2);}
    printf("%2x-%2x\n", valout, valin);
    valout^=0xff;
    sleep(1);
  }
  close(dio);
  return 0;
}
