#include <fcntl.h>
#include <sys/ioctl.h>
#include <asm/ioctl.h>
#include <asm/types.h>
#include <stdio.h>
#include <unistd.h>

#include "nicts.h"

int main(int argc, char *argv[])
{
  int daq, nports, i;
  unsigned char valout=0, valin=0;
  device_info dev_info;
  
  if(argc<2){printf("usage !\n"); return 1;}

  if((daq=open(argv[1],O_RDWR))<0){
    perror("cant open that file"); exit(1);}

  if(ioctl(daq, NICTL_DEVICE_INFO, &dev_info)<0){
      perror("cant ioctl selport"); exit(2);}
  nports=dev_info.dioports;

  /* conf even ports for out, odd for in */

  for(i=0;i<nports;i++){
    if(ioctl(daq, NICTL_DIO_SELPORT, i)<0){
      perror("cant ioctl selport"); exit(2);}
    if(ioctl(daq, NICTL_DIO_CONFPORT, !(i%2))<0){
      perror("cant ioctl confport"); exit(2);}
  }
  
  ioctl(daq, NICTL_DIO_WRMASK, 0x33);

  while(1){
    for(i=0; i<nports;i+=2){
      if(ioctl(daq, NICTL_DIO_SELPORT, i)<0){
	perror("cant ioctl"); exit(2);}
      if(write(daq,&valout,1)<1){
	perror("cant write nidio"); exit(2);}
    }
    printf("%2x: ",valout);

    for(i=1;i<nports;i+=2){
      if(ioctl(daq, NICTL_DIO_SELPORT, i)<0){
	perror("cant ioctl"); exit(2);}
      if(read(daq,&valin,1)<1){
	perror("cant read nidio"); exit(2);}
      printf("%2x ", valin);
    }
    printf("\n");

  valout^=0xff;
  sleep(1);
  }
  close(daq);

  return 0;
}
