/* Reads 1 sample from a given channel at gain=0.5, bipolar mode, differential
converts it to float (12 or 16 bit resolution) and prints the result

usage: ./testaisp <device> <channel_no>
sample: ./testaisp /dev/nidaq0 1
*/

#include <fcntl.h>
#include <asm/ioctl.h>
#include <asm/types.h>
#include <sys/ioctl.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

#include "nicts.h"


int main(int argc, char *argv[])
{
  int daq;
  short binval, chno;
  float volt;
  device_info dinfo;

  if(argc<3){printf("usage !\n"); return 1;}
  if((daq=open(argv[1],O_RDWR))<0){
    perror("cant open that file"); exit(1);}
  
  chno=atoi(argv[2]);

  ioctl(daq, NICTL_DEVICE_INFO, &dinfo);
  ioctl(daq, NICTL_AI_RESET, 0);
  ioctl(daq, NICTL_AI_ADDCH, 0x10008000 | ((chno&0xF) <<16));  
  ioctl(daq, NICTL_AI_ONEPT_SETUP, 0);
  ioctl(daq, NICTL_AI_CONVERT, 0);

  if(read(daq,&binval,2)<2){
    perror("cant read nidaq"); exit(2);}

  if(dinfo.aires==12) volt=binval*10.0/2048; else 
    if(dinfo.aires==16) volt=binval*10.0/32768; else 
      { printf("Invalid resolution\n"); exit(2);}
  printf("%6.3f\n",volt);
   
  close(daq);
  return 0;
}






