#include <dlfcn.h>
#include <asm/types.h>

#include "nicts.h"
#include "extcode.h"

CIN MgErr CINRun(uInt16 *port, uInt32 *read_data, int32 *ti_in, int32 *status);

void *nilib;
int (*LxDioRead)(__s32 fh, __u16 port, __u32 *read_data);

CIN MgErr CINLoad (RsrcFile reserved)
{ 
  nilib=dlopen("/usr/lib/libnidaq.so",RTLD_LAZY);
  if(!nilib)return -1;
  
  LxDioRead=dlsym(nilib, "LxDioRead"); if(dlerror()!=NULL)return -1;
  return noErr;
}

CIN MgErr CINUnload ()
{
  dlclose(nilib);
  return noErr;
}

CIN MgErr CINRun(uInt16 *port, uInt32 *read_data, int32 *ti_in, int32 *status) {
  int dio_handle=*ti_in;

  if((*status=(*LxDioRead)(dio_handle, *port, read_data))<0) return noErr;
  *status=0; return noErr;
}




