#include <dlfcn.h>
#include <asm/types.h>
#include <stdio.h>

#include "nicts.h"
#include "extcode.h"

CIN MgErr CINRun(uInt16 *device, uInt16 *port, uInt32 *rw_mask, int32 *tid_out, int32 *status);

void *nilib;
int (*LxDioOpen)(__u16 device);
int (*LxDioCloseAll)();
int (*LxDioConfPort)(__s32 fh, __u16 port, __u32 rw_mask);

CIN MgErr CINLoad (RsrcFile reserved)
{

  nilib=dlopen("/usr/lib/libnidaq.so",RTLD_LAZY);  
  if(!nilib)return -1;
  LxDioOpen=dlsym(nilib, "LxDioOpen"); if(dlerror()!=NULL)return -1;
  LxDioCloseAll=dlsym(nilib, "LxDioCloseAll"); if(dlerror()!=NULL)return -1;
  LxDioConfPort=dlsym(nilib, "LxDioConfPort"); if(dlerror()!=NULL)return -1;

  return noErr;
}

CIN MgErr CINUnload ()
{

  if(nilib){(*LxDioCloseAll)();dlclose(nilib);}
  return noErr;
}


CIN MgErr CINRun(uInt16 *device, uInt16 *port, uInt32 *rw_mask, int32 *tid_out, int32 *status) {
 
  int fh;

  if((*status=fh=(*LxDioOpen)(*device))<0) return noErr;
  if((*status=(*LxDioConfPort)(fh, *port, *rw_mask)) <0) return noErr;

  *tid_out=fh;

  *status=0; return noErr;
}







