#include <fcntl.h>
#include <asm/ioctl.h>
#include <sys/ioctl.h>
#include <stdio.h>
#include <unistd.h>
#include <asm/types.h>

#include "nicts.h"
#include "extcode.h"

int daq_handle[NI_MAX_BOARDS];
device_info devinfo;

CIN MgErr CINInit(void){}
CIN MgErr CINDispose(void){}
CIN MgErr CINAbort(void){}
CIN MgErr CINSave(RsrcFile reserved){}
CIN MgErr CINProperties(int32 selector, void *arg){}

typedef struct {
	int32 dimSize;
	uInt16 chan_no[1];
	} TD1;
typedef TD1 **TD1Hdl;

typedef struct {
	uInt16 Uni_Bi_Polar;
	uInt16 Gain;
	uInt16 Reference;
	} TD3;

typedef struct {
	int32 dimSize;
	TD3 configuration[1];
	} TD2;
typedef TD2 **TD2Hdl;

typedef struct {
	int32 dimSizes[2];
	float64 output[1];
	} TD4;
typedef TD4 **TD4Hdl;

CIN MgErr CINLoad (RsrcFile reserved)
{
  int i;
  char fname[20];
  for(i=0;i<NI_MAX_BOARDS;i++){
    sprintf(fname,"/dev/nidaq%d",i);
    daq_handle[i] = open (fname, O_RDONLY);
    if (daq_handle[i] <= 0)
      continue;
  }
  return noErr;
}

CIN MgErr CINUnload ()
{
  int i;
  for(i=0;i<NI_MAX_BOARDS;i++)
    if(daq_handle>0) close (daq_handle[i]);
}

CIN MgErr CINRun(int16 *device, TD1Hdl channels, TD2Hdl conf_array, uInt32 *no_scans, float64 *scan_rate, float64 *sample_rate, TD4Hdl output_array, int32 *status);

CIN MgErr CINRun(int16 *device, TD1Hdl channels, TD2Hdl conf_array, uInt32 *no_scans, float64 *scan_rate, float64 *sample_rate, TD4Hdl output_array, int32 *status) {

  uInt32 channel_descriptor, np_to_read, si, si2; int16 i,ii,nch; int16 *rd_data;
  float64 rdflt;
  int err, daqh, rdint, polar;

  if(*device<1 || *device > NI_MAX_BOARDS || daq_handle[*device-1]<0)
    {* status=-10000; return noErr;}
  daqh=daq_handle[*device-1];

  nch=(*channels)->dimSize;
  np_to_read= *no_scans * nch;
  rd_data=(uInt16*)malloc(np_to_read*2);
  if((err=SetCINArraySize((UHandle)output_array, 6, np_to_read)))return err;
  (*output_array)->dimSizes[0]= *no_scans;
  (*output_array)->dimSizes[1]=(*channels)->dimSize;

  ioctl (daqh, NICTL_DEVICE_INFO, &devinfo);
  ioctl (daqh, NICTL_AI_RESET, 0);
  
  i=-1;
  for(ii=0;ii<nch; ii++){
    channel_descriptor = ((*channels)->chan_no[ii] & 0xf) << 16;
    if(ii<(*conf_array)->dimSize)i=ii;
    if(i>=0){
      channel_descriptor |=  ( (*conf_array)->configuration[i].Reference 
			       & 0x7 ) << 28; 
      channel_descriptor |=  ((*conf_array)->configuration[i].Uni_Bi_Polar
			      & 0x1) << 8;
      channel_descriptor |=  ( (*conf_array)->configuration[i].Gain & 0x7);
    } else channel_descriptor |= 0x10000000; /* DIFF, BIP, GAIN=0.5 */
    if(ii==nch-1) channel_descriptor |=  0x8000; /* last channel */   

    ioctl (daqh, NICTL_AI_ADDCH, channel_descriptor);
  }

  si=20e6/(*scan_rate);
  si2=20e6/(*sample_rate);

  ioctl(daqh, NICTL_AI_SET_SC, *no_scans -1);
  ioctl(daqh, NICTL_AI_SET_SI, si-1);
  ioctl(daqh, NICTL_AI_SET_SI2, si2-1);

  
  ioctl(daqh, NICTL_AI_SCAN_SETUP, 0);
  ioctl(daqh, NICTL_AI_SCAN_START, 0);
 

  if ((err=read (daqh, rd_data, 2*np_to_read)) < 2*np_to_read)  {
    *status = -10001; // READ ERROR
    free(rd_data);
    return noErr;
  }

  ii=-1;
  // first bring value to within [0, 1] (or [-.5, .5])

  for(i=0; i<np_to_read; i++){
    if(i%nch<(*conf_array)->dimSize)ii=i%nch;

    polar=ii>=0?(*conf_array)->configuration[ii].Uni_Bi_Polar:0;
    rdint=polar?(unsigned)rd_data[i]:rd_data[i];
    if(devinfo.aires==16) rdflt= rdint / 65536.0; else
      if(devinfo.aires==12)rdflt = rdint / 4096.0; else rdflt=0;
    
    
    switch (ii>=0?(*conf_array)->configuration[ii].Gain  & 0x7 : 0)
      {
      case 0:
	rdflt *= 20.0;
	break;
      case 1:
	rdflt *= 10.0;
	break;
      case 2:
	rdflt *= 5.0;
	break;
      case 3:
	rdflt *= 2.0;
	break;
      case 4:
	rdflt *= 1.0;
	break; 
      case 5:
	rdflt *= 0.5;
	break;  
      case 6:
	rdflt *= 0.2;
	break;
      case 7:
	rdflt *= 0.1;
	break;
      }
    (*output_array)->output[i]=rdflt;
  }

  *status = 0;

  free(rd_data);
  return noErr;
}







