#include <dlfcn.h>
#include <asm/types.h>
#include <stdio.h>

#include "nicts.h"
#include "extcode.h"

/*
 * typedefs
 */

typedef struct {
	int32 dimSize;
	int16 binary_data[1];
	} TD1;
typedef TD1 **TD1Hdl;

typedef struct {
	int32 dimSize;
	float32 scaled_data[1];
	} TD2;
typedef TD2 **TD2Hdl;

CIN MgErr CINRun(int32 *task_id_in, TD1Hdl binary_data, TD2Hdl scaled_data, int32 *status);
void *nilib;
int (*LxAiSingleScan)(__s32 fh, __s16 buff[]);
int (*LxAiGetnch)(__s32 fh);
int (*LxAiScale)(__s32 fh, __u32 nscans,
		 __s16 rddata[], float voltages[]);
CIN MgErr CINLoad (RsrcFile reserved)
{
  nilib=dlopen("/usr/lib/libnidaq.so",RTLD_LAZY);  
  if(!nilib)return -1;
  LxAiSingleScan=dlsym(nilib, "LxAiSingleScan"); if(dlerror()!=NULL)return -1;
  LxAiScale=dlsym(nilib, "LxAiScale"); if(dlerror()!=NULL)return -1;
  LxAiGetnch=dlsym(nilib, "LxAiGetnch"); if(dlerror()!=NULL)return -1;
  return noErr;
}

CIN MgErr CINUnload ()
{
  if(nilib)dlclose(nilib);
  return noErr;
}

CIN MgErr CINRun(int32 *task_id_in, TD1Hdl binary_data, TD2Hdl scaled_data, int32 *status) 
{
  int fh, err, i;
  int16 *buff; uInt16 nch;

  fh=*task_id_in;

  if((*status=nch=(*LxAiGetnch)(fh))<0) return noErr;

  buff=(uInt16 *)malloc(nch *2);
  if(buff==NULL) {*status=-10002; return noErr;}

  if((*status=(*LxAiSingleScan)(fh, buff))<0)
    {free(buff); return noErr;}
  
  if((err=SetCINArraySize((UHandle)binary_data, 1, nch)))
    {free(buff);return err;}
  (*binary_data)->dimSize= nch;

  for(i=0;i<nch;i++)(*binary_data)->binary_data[i]=buff[i];

  if((err=SetCINArraySize((UHandle)scaled_data, 2, nch)))
    {free(buff); return err;}
  (*scaled_data)->dimSize= nch;
  
  (*LxAiScale)(fh, 1, buff, (*scaled_data)->scaled_data);

  free(buff);


  return noErr;
}




