#include <dlfcn.h>
#include <asm/types.h>
#include <stdio.h>

#include "nicts.h"
#include "extcode.h"

/*
 * typedefs
 */

typedef struct {
	int32 dimSizes[2];
	int16 binary_data[1];
	} TD1;
typedef TD1 **TD1Hdl;

typedef struct {
	int32 dimSizes[2];
	float32 scaled_data[1];
	} TD2;
typedef TD2 **TD2Hdl;

CIN MgErr CINRun(int32 *task_id_in, int32 *no_of_scans, TD1Hdl binary_data, TD2Hdl scaled_data, int32 *status);

void *nilib;
int (*LxAiRead)(__s32 fh, __s32 no_scans, __s16 buff[], __s32 *scans_read);
int (*LxAiGetnch)(__s32 fh);
int (*LxAiScale)(__s32 fh, __u32 nscans, __s16 rddata[], float voltages[]);
CIN MgErr CINLoad (RsrcFile reserved)
{
  nilib=dlopen("/usr/lib/libnidaq.so",RTLD_LAZY);  
  if(!nilib)return -1;
  LxAiRead=dlsym(nilib, "LxAiRead"); if(dlerror()!=NULL)return -1;
  LxAiScale=dlsym(nilib, "LxAiScale"); if(dlerror()!=NULL)return -1;
  LxAiGetnch=dlsym(nilib, "LxAiGetnch"); if(dlerror()!=NULL)return -1;
  return noErr;
}

CIN MgErr CINUnload ()
{
  if(nilib)dlclose(nilib);
  return noErr;
}

CIN MgErr CINRun(int32 *task_id_in, int32 *no_of_scans, TD1Hdl binary_data, TD2Hdl scaled_data, int32 *status) 
{
  int fh;
  int16 *buff; uInt16 nch;

  int32 scans_read,i,err, nscans;
  fh=*task_id_in;

  nscans=*no_of_scans; *no_of_scans=0;

  if((*status=nch=(*LxAiGetnch)(fh))<0) return noErr;

  buff=(uInt16 *)malloc(nscans *nch *2);
  if(buff==NULL) {*status=-10002; return noErr;}

  if((*status=(*LxAiRead)(fh, nscans, buff, &scans_read))<0)
    {free(buff); return noErr;}

  if(scans_read!=nscans){*status=-10000; free(buff);return noErr;}

  if((err=SetCINArraySize((UHandle)binary_data, 2, scans_read*nch)))
    {free(buff);return err;}
  (*binary_data)->dimSizes[1]= nch;
  (*binary_data)->dimSizes[0]= scans_read;

  for(i=0;i<scans_read*nch;i++)(*binary_data)->binary_data[i]=buff[i];

  if((err=SetCINArraySize((UHandle)scaled_data, 3, scans_read*nch)))
    {free(buff);return err;}
  (*scaled_data)->dimSizes[1]= nch;
  (*scaled_data)->dimSizes[0]= scans_read;
  
  (*LxAiScale)(fh, scans_read, buff, (*scaled_data)->scaled_data);

  *no_of_scans=scans_read;
  free(buff);
  return noErr;
}
