#include <sys/ioctl.h>
#include <asm/ioctl.h>
#include <asm/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>

#include "../driver/nicts.h"
#include "nidaq.h"

static int aoh[NI_MAX_BOARDS];

int LxAoCloseAll(void)
{
  int i;
  for(i=0;i<NI_MAX_BOARDS;i++)if(aoh[i]>0)close(aoh[i]);
  return 0;
}

int LxAoOpen(__u16 device)
{
  char fname[20];

  if(device<1 || device>NI_MAX_BOARDS) return -1;
  if(aoh[device-1]>0)close(aoh[device-1]);
  sprintf(fname,"/dev/nidaq%d",device-1);
  aoh[device-1]=open(fname,O_WRONLY);
  return aoh[device-1];
}

int LxAoUpdateChannel(__s32 fh, __u16 channel, double voltage)
{
  __s16 voltbin;
  device_info dinfo;

  ioctl(fh, NICTL_DEVICE_INFO, &dinfo);
  ioctl(fh, NICTL_AO_SET_CH, (__u32)channel);
  voltbin=voltage *(1L<<dinfo.aores)/20;
  if(voltbin>2047)voltbin=2047; if(voltbin<-2048)voltbin=-2048;
  if(write(fh, &voltbin, 2)<2) return -10001;
  return 0;
}







