#include <linux/fs.h>
#include <asm/io.h>
#include "eserrlp.h"
#include "daq_driver.h"

#define Board_Base_Address (dev->base)
#define OUTW(w, addr) (dev->type&NI_PCI?writew(w, addr):outw_p(w, addr))
#define INW(addr) (dev->type&NI_PCI?readw(addr):inw_p(addr))
#define OUTB(w, addr) (dev->type&NI_PCI?writeb(w, addr):outb_p(w, addr))
#define INB(addr) (dev->type&NI_PCI?readb(addr):inb_p(addr))

/* DAQ-STC functions */

void DAQ_STC_Windowed_Mode_Write_Byte(pd dev, u32 uRegister_Address, u8 uData)
{
  OUTW(uRegister_Address, Board_Base_Address+Window_Address_Register*2);
  OUTB(uData, Board_Base_Address+Window_Data_Write_Register*2); 
  dev->stccpy[uRegister_Address]=uData;
}

void DAQ_STC_Windowed_Mode_Write(pd dev, u32 uRegister_Address, u16 uData)
{
  OUTW(uRegister_Address, Board_Base_Address+Window_Address_Register*2);
  OUTW(uData, Board_Base_Address+Window_Data_Write_Register*2); 
  dev->stccpy[uRegister_Address]=uData;
}

void DAQ_STC_Windowed_Mode_Masked_Write(pd dev, u32 uRegister_Address, u16 uData, u16 mask)
{
  unsigned short scp;
  scp=(dev->stccpy[uRegister_Address] &~mask) | (uData & mask);
  dev->stccpy[uRegister_Address]=scp;
  OUTW(uRegister_Address, Board_Base_Address+Window_Address_Register*2);
  OUTW(scp, Board_Base_Address+Window_Data_Write_Register*2); 
}

void DAQ_STC_Windowed_Mode_Strobe_Write(pd dev, u32 uRegister_Address, u16 uData)
{
  unsigned short scp;
  scp=dev->stccpy[uRegister_Address] | uData;
  OUTW(uRegister_Address, Board_Base_Address+Window_Address_Register*2);
  OUTW(scp, Board_Base_Address+Window_Data_Write_Register*2); 
}

u8 DAQ_STC_Windowed_Mode_Read_Byte(pd dev, u32 uRegister_Address)
{
        OUTW(uRegister_Address,Board_Base_Address+Window_Address_Register*2);
        return(INB(Board_Base_Address + Window_Data_Read_Register*2)); 
}

u16 DAQ_STC_Windowed_Mode_Read(pd dev, u32 uRegister_Address)
{
        OUTW(uRegister_Address,Board_Base_Address+Window_Address_Register*2);
        return(INW(Board_Base_Address + Window_Data_Read_Register*2)); 
}


/* This function writes to an E-Series board register             */
 
void Board_Write(pd dev, u32 uRegister_Address, u16 uData)
{
  OUTW(uData,Board_Base_Address + uRegister_Address);
}

void Board_Write_Byte(pd dev, u32 uRegister_Address, u8 uData)
{
  // printk("8 write to %x: %x\n", uRegister_Address,uData);
  OUTB(uData, Board_Base_Address + uRegister_Address);
}

/* This function reads from an E-Series board register            */

u16 Board_Read(pd dev, u32 uRegister_Address)
{
 	return INW(Board_Base_Address + uRegister_Address);
}

u8 Board_Read_Byte(pd dev, u32 uRegister_Address)
{
  u8 t;
  t=INB(Board_Base_Address + uRegister_Address);
  // printk("8 read from %x :%x\n", uRegister_Address, t);
  return t;
}

