/* *******************************************************************
 * Distinct ONC RPC/XDR for Java
 * Copyright 1997, 1998 by Distinct Corporation. All rights reserved.
 *********************************************************************/

import java.applet.*;
import java.awt.*;
import java.net.*;
import distinct.rpc.*;

public class couTest {

    public static void main (String args []) {

        cou client;                     // this is the RPC client object
        int cnt;                        // loop index

        // establish TCP connection
        try {
            client = new cou(InetAddress.getByName("localhost"), true);
        }
        catch (Exception e) {           // an error happened
            System.out.println(e.getMessage());
            client = null;
            System.exit (1); // unable to connect
        };
        System.out.println("Connected to counter server");

        // increment remote counter three times
        for (cnt = 0; cnt < 3; cnt++)
        {
            try {
                int i = client.inc_1();     // call it
                System.out.println("RPC returns: " + i);
            }
            catch (Exception e) {           // an RPC error happened
                System.out.println(e.getMessage());
                break;
            };
        }

        // check if previous loop was successful
        if (cnt == 3)
        {
            // decrement remote counter three times
            for (cnt = 0; cnt < 3; cnt++)
            {
                try {
                    int i = client.dec_1();     // call it
                    System.out.println("RPC returns: " + i);
                }
                catch (Exception e) {           // an RPC error happened
                    System.out.println(e.getMessage());
                    break;
                };
            }
        }

        // destroy client and close socket
        if (client != null)
        {
            client.GetClient().close();
            client = null;
        }
        System.exit (0); // success
    }
}
