/* *******************************************************************
 * Distinct ONC RPC/XDR for Java
 * Copyright 1997 - 1999 by Distinct Corporation. All rights reserved.
 *********************************************************************/

import distinct.rpc.*;
import java.io.*;

public class SecureServer extends couServer {
    
    int i;
    AuthDesServerDB adb;

    static public void main(String[] args) {
        try {
            new SecureServer();
        }
        catch (RPCError e) {
            System.err.println(e.getMessage());
            System.exit(-1);
        }
    }    

    public SecureServer() throws RPCError {
        super();
        try {
            PublicKeyDB DB = new PublicKeyDB(new File("publickey"));
            if (!DB.doLogin(false))
                System.exit(-1);
            adb = new AuthDesServerDB(DB.getNetname(), DB.getPassword(), DB);
            System.err.println("Secure RPC initialized");
        }
        catch(IOException e) {
            System.out.println(e.getMessage());
            throw new RPCError("File Error");
        }
    }

    synchronized public Auth DoAuth(int proc, Auth cred, Auth verf) throws RPCAuthError {
        Auth ret = adb.checkAuth(cred, verf).getVerifier();
        return ret;
    }
    
    public int inc_1() {
        System.out.println("inc");
        i++; return i;}

    public int dec_1() {
        System.out.println("dec");
        i--; return i;}

    public int set_1(int arg) {
        System.out.println("set");
        i = arg; return i;}
}
