/* *******************************************************************
 * Distinct ONC RPC/XDR for Java
 * Copyright 1997 - 1999 by Distinct Corporation. All rights reserved.
 *********************************************************************/

import distinct.rpc.*;
import java.net.*;
import java.io.*;
import java.awt.*;

public class SecureClient {

    public static void main (String args [ ]) {
        cou client;                 // this is the RPC client object

        if (args.length != 2) {
            System.err.println("usage: SecureClient <servername> <server-owner-netname>");
            System.exit (-1);
        }

        try {
            PublicKeyDB DB = new PublicKeyDB(new File("publickey"));
            if (!DB.doLogin(false))
                System.exit(-1);
            AuthDes a = new AuthDes(DB.getNetname(), DB.getPassword(),
                args[1], DB, 1800);

            ClientSecureRPC cl_sec = new ClientSecureRPC(
                InetAddress.getByName(args[0]),
                cou.COUNTSERV, cou.COUNTVERS,
                true, a);
            client = new cou(cl_sec);
            client.SetTimeout(0);
        }
        catch (Exception e) {       // an error happened
            printStr(e.getMessage());
            client = null;
            System.exit(-1);
        };
        printStr("Connected to counter server");

        for (int i=0; i < 10; i++)
        try {
            int j = client.inc_1(); // call it
            printStr("RPC returns: " + j);
        }
        catch (Exception e) {       // an RPC error happened
            printStr(e.getMessage());    
            System.exit(-1);
        };
        System.exit(0);
    }

    static void printStr(String newWord) {
        System.err.println(newWord);
    }
}
