/* *******************************************************************
 * Distinct ONC RPC/XDR for Java
 * Copyright 1997, 1998 by Distinct Corporation. All rights reserved.
 *********************************************************************/

import java.net.*;
import java.io.*;
import distinct.rpc.*;

public class PmapTest implements distinct.rpc.XDRType{

        public static final int kIPPROTO_TCP = 6;
        public static final int kIPPROTO_UDP= 17;

        public static final int PMAPPORT = 111;
        public static final int PMAPPROG = 100000;
        public static final int PMAPVERS = 2;
        public static final int PMAPVERS_PROTO = 2;
        public static final int PMAPVERS_ORIG = 1;
        public static final int PMAPPROC_NULL = 0;
        public static final int PMAPPROC_SET = 1;
        public static final int PMAPPROC_UNSET = 2;
        public static final int PMAPPROC_GETPORT = 3;
        public static final int PMAPPROC_DUMP = 4;
        public static final int PMAPPROC_CALLIT = 5;

        int prog;
        int vers;
        int prot;
        int port;

        public static void main(String args[]) {

        try {
                PmapTest p = new PmapTest(77,1,kIPPROTO_TCP,0);
                int port = p.getPort(InetAddress.getByName("localhost"));
                System.err.println("Got Port:" + port);
        }
        catch (Exception e) {
                System.err.println(e.getMessage());
        }
        System.exit (0); // success
}


        public PmapTest() {};

/**
 * Creates a portmapper entry.
 * @param progp      The program ID.
 * @param versp      The version of the program.
 * @param protp      The protocol identifier (kIPPROTO_TCP or kIPPROTO_UDP).
 * @param portp      The port number.
 */

        public PmapTest(int progp, int versp, int protp, int portp) {
                prog = progp;
                vers = versp;
                prot = protp;
                port = portp;
        }


/**
 * Encodes a portmapper entry in compliance to RFC 1832 (XDR).
 * @param     xdrs The XDR output stream.
 */

        public void xdr_encode(XDRStream xdrs)
        {
                xdrs.xdr_encode_int(prog);
                xdrs.xdr_encode_int(vers);
                xdrs.xdr_encode_int(prot);
                xdrs.xdr_encode_int(port);
                return;
        };


/**
 * Decodes a portmapper entry in compliance to RFC 1832 (XDR).
 * @param     xdrs The XDR input stream.
 */

        public void xdr_decode(XDRStream xdrs) throws RPCError
        {
                prog = xdrs.xdr_decode_int();
                vers = xdrs.xdr_decode_int();
                prot = xdrs.xdr_decode_int();
                port = xdrs.xdr_decode_int();
                return;
        };



/**
 * Requests the portnumber of an entry in the portmapper of a given host.
 * This method creates a temporary UDP client for calling the portmapper.
 * @param     host The host where the portmapper lives.
 * @return    The port number on success, 0 on error.
 */

        public int getPort(InetAddress host) throws IOException, RPCError
        {
                ClientUDP cl = null;
                XDRint ret = new XDRint();

                cl = new ClientUDP(host, PMAPPROG, PMAPVERS, PMAPPORT);
                cl.Call(PMAPPROG, PMAPVERS, PMAPPROC_GETPORT, this, ret);

                return ret.value;
        };
}
