/* ***************************************
 * Distinct ONC RPC/XDR for Java RPCInfo *
 ****************************************/

import distinct.rpc.*;
import java.io.*;
import java.net.*;
import java.util.*;

public class RPCInfo {

    // program entry point
    public static void main (String args []) {

        String server;          // server machine
        String buffer;          // output buffer

        PmapDump dump;          // client object
        PmapList list;          // service list
        PmapEntry entry;        // service entry
        RPCEntry info;          // entry information

	String FileSeparator;	// operating system file separator
	String ClassPath;	// CLASSPATH environment variable
	String PathSeparator;	// operating system class path separator

        File fRPC;              // RPC data base file
	boolean found;		// file search flag
        NetDB svc;              // RPC services data base

        // get name of server machine
        if (args.length > 1) {
            System.out.println ("Too many command line arguments");
            System.out.println ("Usage: RPCInfo [server]");
            System.exit (1);  // usage error
        }
        if (args.length == 1)
            server = args [0];
        else server = "localhost";

        // establish TCP connection
        dump = null;
        try {
            dump = new PmapDump (InetAddress.getByName (server), true);
        }
        catch (Exception e) {
            System.out.println (e.getMessage ());
            dump = null;
            System.exit (2); // unable to connect error
        };

        // ask server for list of registered services
        list = null;
        try {
            list = dump.list_2 ();
        }
        catch (Exception e) {
            System.out.println (e.getMessage ());
            dump = null;
            System.exit (3); // remote call failed
        };
 
        // destroy client and close socket
        dump.GetClient ().close ();
        dump = null;

	// get operating system dependent values
	FileSeparator = System.getProperty ("file.separator");
	ClassPath = System.getProperty ("java.class.path");
	PathSeparator = System.getProperty ("path.separator");

	// look in current directory for RPC services data base file
	found = false;
	fRPC = new File ("." + FileSeparator + "RPC");
	if (fRPC.canRead () == true)
	    found = true;
	else fRPC = null;

	// loop through all class path directories if not found
	if (found == false) {
    	    StringTokenizer t = new StringTokenizer (ClassPath, PathSeparator);
	    int i;
	    int tokenCount = t.countTokens ();

            for (i = 0; i < tokenCount; i++) {
		fRPC = new File (t.nextToken () + FileSeparator + "RPC");
		if (fRPC.canRead () == true) {
		    found = true;
		    break;
		}
		fRPC = null;
	    }
	}

	// check if RPC services data base file was found
        svc = null;
	if (found == true) {
            // open RPC services data base file
            try {
                svc = new NetDB (fRPC);
            }
            catch (IOException e) {
                // display warning message
                System.out.println ("Unable to open RPC data base file");
	    };
        }
	else
	{
	    // display warning message
	    System.out.println ("Unable to find RPC data base file");
	}

        // print output header
        System.out.println ("    Program  Ver  Proto   Port  Service");

        // display registered services
        buffer = null;
        entry = list.value;
        while (entry != null) { 
            // print program number and version
            format (buffer.valueOf (entry.prog), 11);
            format (buffer.valueOf (entry.vers), 4);

            // print protocol name
            if (entry.prot == 6)
                format ("TCP", 7);
            else if (entry.prot == 17)
                format ("UDP", 7);
            else format ("- ", 7);

            // print port
            format (buffer.valueOf (entry.port), 8);
            System.out.print ("  ");

            // print name of service
            if (svc != null) {
                info = svc.getrpcbynumber (entry.prog);
                if (info != null)
                    System.out.println (info.getName ());
                else System.out.println ("-");
            }
            else System.out.println ("-");

            // go to next entry
            entry = entry.next;
        }
        System.exit (0); // success
    }

    // display string right justified in given width
    static void format (String arg, int width) {
        // get string length
        int len = arg.length ();

        // prefix strings shorter than given width
        if (len < width) {
            // find out how many leading spaces are needed
            int i = width - len;

            // print out enough leading spaces to right justify
            while (i > 0) {
                System.out.print (" ");
                i--;
            }
        }

        // print out right justified string
        System.out.print (arg);
    }
}
