/* ***************************************
 * Distinct ONC RPC/XDR for Java RPCInfo *
 ****************************************/

import distinct.rpc.*;
import java.io.IOException;
import java.net.InetAddress;

/**
 * This class was automatically generated by Jrpcgen from the RPC/XDR file "PmapDump.x" <br>.
 * It defines the client interface to a server implementing the "PmapDump" interface.
 */

public class PmapDump extends JRPCClient {

/** Program ID of the interface. */
public static final int RPCINFO_SERVER = 100000;

/** Version of the interface. */
public static final int RPCINFO_VERSION = 2;

/**
 * Creates and connects an RPC client for a server that implements the "PmapDump" interface.
 * Calls the remote Portmapper in order to get the port of the server.
 * @param host       The host on which the server lives.
 * @param stream     true for a TCP connection, false for UDP.
 * @exception        RPCError When the calls fails for any reason.
 */
public PmapDump(InetAddress host, boolean stream) throws RPCError {
	super(host, RPCINFO_SERVER, RPCINFO_VERSION, stream);
}

/**
 * Creates and connects an RPC client for a server that implements the "PmapDump" interface.
 * The client is connected it to a server with a known port. (No interaction with a portmapper)
 * @param host       The host on which the server lives.
 * @param port       The port on which the server listens.
 * @param stream     true for a TCP connection, false for UDP.
 * @exception        RPCError When the calls fails for any reason.
 */
public PmapDump(InetAddress host, int port, boolean stream) throws RPCError {
	super(host, RPCINFO_SERVER, RPCINFO_VERSION, port, stream);
}

/**
 * Creates an RPC client for a server that implements the "PmapDump" interface.
 * It initializes it with a externally created protocol client object.
 * @param protocol   The protocol object that implements the client connection.
 */
public PmapDump(ClientGeneric protocol) {
	super(protocol);
}

public static final int list = 4;

/**
 * Stub method that invokes the server function "list" (version 2).
 */
public PmapList list_2() throws RPCError, IOException {
	XDRvoid arg_ref = new XDRvoid();

	PmapList retval = new PmapList();

	GetClient().Call(list, arg_ref, retval);

	return retval;
}
};
