/*********************************************************************
 * Distinct ONC RPC/XDR for Java
 * Copyright 1997 - 1999 by Distinct Corporation. All rights reserved.
 *********************************************************************/

import java.io.*;
import java.util.*;
import java.text.SimpleDateFormat;
import java.net.InetAddress;

import distinct.rpc.*;

public class RPCGWCGI {
	RandomAccessFile logfd = null;
	boolean secure = true;
	File configFile;
	SimpleDateFormat formatter;
	ACLEntry ACL = null;
	String br = "\n";

	class XDRraw implements XDRType{

		public byte[] value;

		public void xdr_encode(XDRStream xdrs)
		{
			xdrs.put_bytes(value, value.length);
			return;
		};

		public void xdr_decode(XDRStream xdrs) throws RPCError
		{
			value = xdrs.get_bytes(xdrs.get_length());
			return;
		};
	};

	class ACLEntry {
		String host;
		int prog;
		int vers;
		String prot;
		int proc;

		ACLEntry next;

		ACLEntry() {
			host = prot = "";
			prog = vers = proc = -1;
		}						
	}

	static public void main(String[] args) {

		if (!System.getProperty("REQUEST_METHOD", "GET").equals("POST")) {
			System.out.print("Content-type: text/html\n\nIllegal request method.\n");
			return;
		}

		RPCGWCGI gw = new RPCGWCGI();
		gw.doPost();
		System.exit(0);
	}

	synchronized void readConfig(File configFile) throws IOException {
		FileReader fr;

		ACL = null;
		fr = new FileReader(configFile);
		BufferedReader r = new BufferedReader(fr);

		while (true) {
			StringTokenizer s;

			try {
				String str= r.readLine();
				if (str == null)
					break;
				s = new StringTokenizer(str, " \t");
			}
			catch (IOException e) {
				break;
			}

			if (s.countTokens() != 5)
				continue;

			String token = s.nextToken();
			if (token.charAt(0) == '#')
				continue;

			ACLEntry e = new ACLEntry();
			
			e.host = token;

			token = s.nextToken();
			if (token.equals("*"))
				e.prog = -1;
			else
				e.prog = Integer.parseInt(token, 10);

			token = s.nextToken();
			if (token.equals("*"))
				e.vers = -1;
			else
				e.vers = Integer.parseInt(token, 10);

			e.prot = s.nextToken();

			token = s.nextToken();
			if (token.equals("*"))
				e.proc = -1;
			else
				e.proc = Integer.parseInt(token, 10);

			e.next = ACL;
			ACL = e;
		}
		fr.close();
	}

	synchronized boolean checkACL(String host, int prog, int vers, boolean useTCP, int proc) {
		for (ACLEntry acl = ACL; acl != null; acl = acl.next) {
			if ((acl.prog == -1) || (acl.prog == prog))
				if ((acl.vers == -1) || (acl.vers == vers))
					if ((acl.proc == -1) || (acl.proc == proc))
						if (acl.host.equals("*") || acl.host.equals(host))
							if (acl.prot.equals("*") || acl.prot.equals(useTCP?"tcp":"udp"))
								return true;
		}
		return false;
	}

	void doPost()
	{
		try {
			br = System.getProperty("line.separator", "\n");

			String logFileName = System.getProperty("LogFileName");
			if (logFileName != null) {
				logfd = new RandomAccessFile(logFileName, "rw");
				logfd.seek(logfd.length());
			}

			String dateFormat = System.getProperty("DateFormat", "EEE, MMM d, yyyy HH:mm:ss");
			formatter = new SimpleDateFormat(dateFormat);

			if (logfd != null) {

				logfd.writeBytes("["+formatter.format(new Date())+"] ");

				String host = System.getProperty("REMOTE_HOST");
				if (host != null)
					logfd.writeBytes(host+" ");
				else {
					String addr = System.getProperty("REMOTE_ADDR");
					if (addr != null)
						logfd.writeBytes(addr+" ");
				}
			}

			InputStream instr = System.in;
			XDRStream xdrsin = new XDRStream();
			int len = Integer.parseInt(
				System.getProperty("CONTENT_LENGTH"), 10);

			while (len > 0) {
				len--;
				char c = (char)instr.read();
				switch (c) {
				  case '+':
					xdrsin.put_byte((byte)' ');
					break;
				  case '%':
					try {
						StringBuffer s = new StringBuffer();
						s.append((char)instr.read());
						s.append((char)instr.read());
						xdrsin.put_byte((byte) Integer.parseInt(s.toString(), 16));
						len -= 2;
					} catch (NumberFormatException e) {
						throw new IllegalArgumentException();
					}
					break;
				  default:
					xdrsin.put_byte((byte)c);
					break;
				}
			}

			byte id[] = xdrsin.get_bytes(4);
			String RPCHost = xdrsin.xdr_decode_string();		
			int prog = xdrsin.xdr_decode_int();		
			int vers = xdrsin.xdr_decode_int();		
			int proc = xdrsin.xdr_decode_int();		
			boolean useTCP = xdrsin.xdr_decode_boolean();		
			int Timeout = xdrsin.xdr_decode_int();		
			XDRraw in = new XDRraw();
			in.xdr_decode(xdrsin);

			if (logfd != null)
				logfd.writeBytes("request "+RPCHost+","+prog+","+vers+","+(useTCP?"tcp":"udp")+","+proc);

			String security = System.getProperty("Security");
			if (security != null)
				if (security.equals("false"))
					secure = false;
			
			if (secure) {
				String configFileName = System.getProperty("ConfigFileName", "rpcgw.cfg");
				configFile = new File(configFileName);
				readConfig(configFile);

				if (!checkACL(RPCHost, prog, vers, useTCP, proc))
					throw new RPCError("Security violation", 0);
			}

			JRPCClient cl = new JRPCClient(InetAddress.getByName(RPCHost), prog, vers, useTCP); 
			cl.SetTimeout(Timeout);
			XDRraw out = new XDRraw();
			cl.Call(proc, in, out);
			cl.CloseClient();

			System.out.print("Content-type: application/octet-stream\n\n");
			System.out.write(id);
			System.out.write(out.value);

			if (logfd != null)
				logfd.writeBytes(" successful"+br);
		}
		catch (RPCError e) {
			try {
				if (logfd != null)
					logfd.writeBytes(" Error : "+e.getMessage()+br);
			}
			catch (IOException ioe) {}

			System.out.print("Content-type: text/html\n\n");
			System.out.print(e.getMessage());
		}
		catch (IOException e) {
			try {
				if (logfd != null)
					logfd.writeBytes(" Error : "+e.toString()+br);
			}
			catch (IOException ioe) {}

			System.out.print("Content-type: text/html\n\n");
			System.out.print(e.toString());
		}
	}
}
