#include <iostream.h>
#include <fstream.h>
#include "ndds/NDDS.h"
#include "SAS_Config.h"
#include "nddsMsgNames.h"

#include "bodDerivedState.h"
#include "gpsDerivedState.h"
#include "kvhDerivedState.h"
#include "move.h"
#include "posDerivedState.h"
#include "rtAmpState.h"
#include "rtControlState.h"
#include "rtEmergencySignals.h"
#include "weatherState.h"

#include "dbMsgs.h"
#include "sensManMsgs.h"
#include "sensorMsgs.h"
#include "targetAcqMsgs.h"
#include "telemetryMsgs.h"

#define TELEMETRY_DEADLINE 10.0f
#define TELEMETRY_MIN_SEPARATION 0.0f 

RTIBool bodDerivedStateCallback(NDDSRecvInfo *issue) {
  bodDerivedState *item = (bodDerivedState *)issue->instance;
  bodDerivedState *msg = (bodDerivedState *)issue->callBackRtnParam;
  if (issue->status == NDDS_FRESH_DATA) {
    memcpy(msg, item, sizeof(bodDerivedState));
  }
  return(RTI_TRUE);
}

RTIBool gpsDerivedStateCallback(NDDSRecvInfo *issue) {
  gpsDerivedState *item = (gpsDerivedState *)issue->instance;
  gpsDerivedState *msg = (gpsDerivedState *)issue->callBackRtnParam;
  if (issue->status == NDDS_FRESH_DATA) {
    memcpy(msg, item, sizeof(gpsDerivedState));
  }
  return(RTI_TRUE);
}

RTIBool kvhDerivedStateCallback(NDDSRecvInfo *issue) {
  kvhDerivedState *item = (kvhDerivedState *)issue->instance;
  kvhDerivedState *msg = (kvhDerivedState *)issue->callBackRtnParam;
  if (issue->status == NDDS_FRESH_DATA) {
    memcpy(msg, item, sizeof(kvhDerivedState));
  }
  return(RTI_TRUE);
}

RTIBool moveCallback(NDDSRecvInfo *issue) {
  move *item = (move *)issue->instance;
  move *msg = (move *)issue->callBackRtnParam;
  if (issue->status == NDDS_FRESH_DATA) {
    memcpy(msg, item, sizeof(move));
  }
  return(RTI_TRUE);
}

RTIBool posDerivedStateCallback(NDDSRecvInfo *issue) {
  posDerivedState *item = (posDerivedState *)issue->instance;
  posDerivedState *msg = (posDerivedState *)issue->callBackRtnParam;
  if (issue->status == NDDS_FRESH_DATA) {
    memcpy(msg, item, sizeof(posDerivedState));
  }
  return(RTI_TRUE);
}

RTIBool rtAmpStateCallback(NDDSRecvInfo *issue) {
  rtAmpState *item = (rtAmpState *)issue->instance;
  rtAmpState *msg = (rtAmpState *)issue->callBackRtnParam;
  if (issue->status == NDDS_FRESH_DATA) {
    memcpy(msg, item, sizeof(rtAmpState));
  }
  return(RTI_TRUE);
}

RTIBool rtControlStateCallback(NDDSRecvInfo *issue) {
  rtControlState *item = (rtControlState *)issue->instance;
  rtControlState *msg = (rtControlState *)issue->callBackRtnParam;
  if (issue->status == NDDS_FRESH_DATA) {
    memcpy(msg, item, sizeof(rtControlState));
  }
  return(RTI_TRUE);
}

RTIBool rtEmergencySignalsCallback(NDDSRecvInfo *issue) {
  rtEmergencySignals *item = (rtEmergencySignals *)issue->instance;
  rtEmergencySignals *msg = (rtEmergencySignals *)issue->callBackRtnParam;
  if (issue->status == NDDS_FRESH_DATA) {
    memcpy(msg, item, sizeof(rtEmergencySignals));
  }
  return(RTI_TRUE);
}

RTIBool weatherStateCallback(NDDSRecvInfo *issue) {
  weatherState *item = (weatherState *)issue->instance;
  weatherState *msg = (weatherState *)issue->callBackRtnParam;
  if (issue->status == NDDS_FRESH_DATA) {
    memcpy(msg, item, sizeof(weatherState));
  }
  return(RTI_TRUE);
}

RTIBool armDerivedStateCallback(NDDSRecvInfo *issue) {
  armDerivedState *item = (armDerivedState *)issue->instance;
  armDerivedState *msg = (armDerivedState *)issue->callBackRtnParam;
  if (issue->status == NDDS_FRESH_DATA) {
    memcpy(msg, item, sizeof(armDerivedState));
  }
  return(RTI_TRUE);
}

RTIBool hiResDerivedStateCallback(NDDSRecvInfo *issue) {
  hiResDerivedState *item = (hiResDerivedState *)issue->instance;
  hiResDerivedState *msg = (hiResDerivedState *)issue->callBackRtnParam;
  if (issue->status == NDDS_FRESH_DATA) {
    memcpy(msg, item, sizeof(hiResDerivedState));
  }
  return(RTI_TRUE);
}

RTIBool laserDerivedStateCallback(NDDSRecvInfo *issue) {
  laserDerivedState *item = (laserDerivedState *)issue->instance;
  laserDerivedState *msg = (laserDerivedState *)issue->callBackRtnParam;
  if (issue->status == NDDS_FRESH_DATA) {
    memcpy(msg, item, sizeof(laserDerivedState));
  }
  return(RTI_TRUE);
}

RTIBool dbNotifyCallback(NDDSRecvInfo *issue) {
  dbNotify *item = (dbNotify *)issue->instance;
  dbNotify *msg = (dbNotify *)issue->callBackRtnParam;
  if (issue->status == NDDS_FRESH_DATA) {
    memcpy(msg, item, sizeof(dbNotify));
  }
  return(RTI_TRUE);
}

RTIBool sensManCompleteCallback(NDDSRecvInfo *issue) {
  sensManComplete *item = (sensManComplete *)issue->instance;
  sensManComplete *msg = (sensManComplete *)issue->callBackRtnParam;
  if (issue->status == NDDS_FRESH_DATA) {
    memcpy(msg, item, sizeof(sensManComplete));
  }
  return(RTI_TRUE);
}

RTIBool targetAcqCompleteCallback(NDDSRecvInfo *issue) {
  targetAcqComplete *item = (targetAcqComplete *)issue->instance;
  targetAcqComplete *msg = (targetAcqComplete *)issue->callBackRtnParam;
  if (issue->status == NDDS_FRESH_DATA) {
    memcpy(msg, item, sizeof(targetAcqComplete));
  }
  return(RTI_TRUE);
}


int main(int argc, char *argv[]) {

  int nddsDomain;
  float period;
  if(!getSAS_Config(NDDS_DOMAIN, nddsDomain)) {
    cerr << "[telemetryLogger] ERROR: Cannot read " << NDDS_DOMAIN << " from config file!" << endl;
    return(-1);
  }
  if(!getSAS_Config(TELEMETRY_LOG_PERIOD, period)) {
    cerr << "[telemetryLogger] ERROR: Cannot read " << TELEMETRY_LOG_PERIOD << " from config file!" << endl;
    return(-1);
  }

  char logFileName[100];
  long ltime;
  time(&ltime);
  sprintf(logFileName, "log.%d.txt", ltime);
  fstream logFile;
  logFile.open(logFileName, ios::out);
  if(logFile.fail()) {
    cerr << "[telemetryLogger] ERROR: Cannot open " << logFileName << " for writing!" << endl;
    return(-1);
  }

  NddsInit(nddsDomain, NULL);
  cerr << "[telemetryLogger] Initialized NDDS" << endl;
  cerr << "[telemetryLogger] Saving telemetry to \"" << logFileName << "\"" << endl;

  // Published telemetry messages to/from realtime
  bodDerivedStateNddsRegister();
  gpsDerivedStateNddsRegister();
  kvhDerivedStateNddsRegister();
  moveNddsRegister();
  posDerivedStateNddsRegister();
  rtAmpStateNddsRegister();
  rtControlStateNddsRegister();
  rtEmergencySignalsNddsRegister();
  weatherStateNddsRegister();

  // Published telemetry-type messages from SAS
  armDerivedStateNddsRegister();
  hiResDerivedStateNddsRegister();
  laserDerivedStateNddsRegister();
  dbNotifyNddsRegister();
  sensManCompleteNddsRegister();
  targetAcqCompleteNddsRegister();
  
  // Published telemetry-type messages to/from realtime
  bodDerivedState *bodDerivedStateMsg       = (bodDerivedState *)calloc(1, sizeof(bodDerivedState));
  gpsDerivedState *gpsDerivedStateMsg       = (gpsDerivedState *)calloc(1, sizeof(gpsDerivedState));
  kvhDerivedState *kvhDerivedStateMsg       = (kvhDerivedState *)calloc(1, sizeof(kvhDerivedState));
  move *moveMsg                             = (move *)calloc(1, sizeof(move));
  posDerivedState *posDerivedStateMsg       = (posDerivedState *)calloc(1, sizeof(posDerivedState));
  rtAmpState *rtAmpStateMsg                 = (rtAmpState *)calloc(1, sizeof(rtAmpState));
  rtControlState *rtControlStateMsg         = (rtControlState *)calloc(1, sizeof(rtControlState));
  rtEmergencySignals *rtEmergencySignalsMsg = (rtEmergencySignals *)calloc(1, sizeof(rtEmergencySignals));
  weatherState *weatherStateMsg             = (weatherState *)calloc(1, sizeof(weatherState));

  // Published telemetry-type messages from SAS
  armDerivedState *armDerivedStateMsg     = (armDerivedState *)calloc(1, sizeof(armDerivedState));
  hiResDerivedState *hiResDerivedStateMsg = (hiResDerivedState *)calloc(1, sizeof(hiResDerivedState));
  laserDerivedState *laserDerivedStateMsg = (laserDerivedState *)calloc(1, sizeof(laserDerivedState));
  dbNotify *dbNotifyMsg                   = (dbNotify *)calloc(1, sizeof(dbNotify));
  sensManComplete *sensManCompleteMsg     = (sensManComplete *)calloc(1, sizeof(sensManComplete));
  targetAcqComplete *targetAcqCompleteMsg = (targetAcqComplete *)calloc(1, sizeof(targetAcqComplete));

  NDDSSubscriber sub = NddsSubscriberCreate();
  NddsSubscriberSubscriptionAdd(sub, NddsSubscriptionCreate(NDDS_SUBSCRIPTION_IMMEDIATE, BOD_DERIVED_STATE_MSG_NAME,
							    bodDerivedStatePublicationType, bodDerivedStateMsg,
							    TELEMETRY_DEADLINE, TELEMETRY_MIN_SEPARATION, 
							    bodDerivedStateCallback, bodDerivedStateMsg));
  NddsSubscriberSubscriptionAdd(sub, NddsSubscriptionCreate(NDDS_SUBSCRIPTION_IMMEDIATE, GPS_DERIVED_STATE_MSG_NAME,
							    gpsDerivedStatePublicationType, gpsDerivedStateMsg,
							    TELEMETRY_DEADLINE, TELEMETRY_MIN_SEPARATION, 
							    gpsDerivedStateCallback, gpsDerivedStateMsg));
  NddsSubscriberSubscriptionAdd(sub, NddsSubscriptionCreate(NDDS_SUBSCRIPTION_IMMEDIATE, KVH_DERIVED_STATE_MSG_NAME,
							    kvhDerivedStatePublicationType, kvhDerivedStateMsg,
							    TELEMETRY_DEADLINE, TELEMETRY_MIN_SEPARATION, 
							    kvhDerivedStateCallback, kvhDerivedStateMsg));
  NddsSubscriberSubscriptionAdd(sub, NddsSubscriptionCreate(NDDS_SUBSCRIPTION_IMMEDIATE, MOVE_MSG_NAME,
							    movePublicationType, moveMsg,
							    TELEMETRY_DEADLINE, TELEMETRY_MIN_SEPARATION, 
							    moveCallback, moveMsg));
  NddsSubscriberSubscriptionAdd(sub, NddsSubscriptionCreate(NDDS_SUBSCRIPTION_IMMEDIATE, POS_DERIVED_STATE_MSG_NAME,
							    posDerivedStatePublicationType, posDerivedStateMsg,
							    TELEMETRY_DEADLINE, TELEMETRY_MIN_SEPARATION, 
							    posDerivedStateCallback, posDerivedStateMsg));
  NddsSubscriberSubscriptionAdd(sub, NddsSubscriptionCreate(NDDS_SUBSCRIPTION_IMMEDIATE, RT_AMP_STATE_MSG_NAME,
							    rtAmpStatePublicationType, rtAmpStateMsg,
							    TELEMETRY_DEADLINE, TELEMETRY_MIN_SEPARATION, 
							    rtAmpStateCallback, rtAmpStateMsg));
  NddsSubscriberSubscriptionAdd(sub, NddsSubscriptionCreate(NDDS_SUBSCRIPTION_IMMEDIATE, RT_CONTROL_STATE_MSG_NAME,
							    rtControlStatePublicationType, rtControlStateMsg,
							    TELEMETRY_DEADLINE, TELEMETRY_MIN_SEPARATION, 
							    rtControlStateCallback, rtControlStateMsg));
  NddsSubscriberSubscriptionAdd(sub, NddsSubscriptionCreate(NDDS_SUBSCRIPTION_IMMEDIATE, RT_EMERGENCY_SIGNALS_MSG_NAME,
							    rtEmergencySignalsPublicationType, rtEmergencySignalsMsg,
							    TELEMETRY_DEADLINE, TELEMETRY_MIN_SEPARATION, 
							    rtEmergencySignalsCallback, rtEmergencySignalsMsg));
  NddsSubscriberSubscriptionAdd(sub, NddsSubscriptionCreate(NDDS_SUBSCRIPTION_IMMEDIATE, WEATHER_STATE_MSG_NAME,
							    weatherStatePublicationType, weatherStateMsg,
							    TELEMETRY_DEADLINE, TELEMETRY_MIN_SEPARATION, 
							    weatherStateCallback, weatherStateMsg));
  NddsSubscriberSubscriptionAdd(sub, NddsSubscriptionCreate(NDDS_SUBSCRIPTION_IMMEDIATE, ARM_DERIVED_STATE_MSG_NAME,
							    armDerivedStatePublicationType, armDerivedStateMsg,
							    TELEMETRY_DEADLINE, TELEMETRY_MIN_SEPARATION, 
							    armDerivedStateCallback, armDerivedStateMsg));
  NddsSubscriberSubscriptionAdd(sub, NddsSubscriptionCreate(NDDS_SUBSCRIPTION_IMMEDIATE, HI_RES_DERIVED_STATE_MSG_NAME,
							    hiResDerivedStatePublicationType, hiResDerivedStateMsg,
							    TELEMETRY_DEADLINE, TELEMETRY_MIN_SEPARATION, 
							    hiResDerivedStateCallback, hiResDerivedStateMsg));
  NddsSubscriberSubscriptionAdd(sub, NddsSubscriptionCreate(NDDS_SUBSCRIPTION_IMMEDIATE, LASER_DERIVED_STATE_MSG_NAME,
							    laserDerivedStatePublicationType, laserDerivedStateMsg,
							    TELEMETRY_DEADLINE, TELEMETRY_MIN_SEPARATION, 
							    laserDerivedStateCallback, laserDerivedStateMsg));
  NddsSubscriberSubscriptionAdd(sub, NddsSubscriptionCreate(NDDS_SUBSCRIPTION_IMMEDIATE, DB_NOTIFY_MSG_NAME,
							    dbNotifyPublicationType, dbNotifyMsg,
							    TELEMETRY_DEADLINE, TELEMETRY_MIN_SEPARATION, 
							    dbNotifyCallback, dbNotifyMsg));
  NddsSubscriberSubscriptionAdd(sub, NddsSubscriptionCreate(NDDS_SUBSCRIPTION_IMMEDIATE, SENS_MAN_COMPLETE_MSG_NAME,
							    sensManCompletePublicationType, sensManCompleteMsg,
							    TELEMETRY_DEADLINE, TELEMETRY_MIN_SEPARATION, 
							    sensManCompleteCallback, sensManCompleteMsg));
  NddsSubscriberSubscriptionAdd(sub, NddsSubscriptionCreate(NDDS_SUBSCRIPTION_IMMEDIATE, TARGET_ACQ_COMPLETE_MSG_NAME,
							    targetAcqCompletePublicationType, targetAcqCompleteMsg,
							    TELEMETRY_DEADLINE, TELEMETRY_MIN_SEPARATION, 
							    targetAcqCompleteCallback, targetAcqCompleteMsg));
  while(1) {
    time(&ltime);
    logFile << ltime << " " << period << endl;
    logFile << "armDerivedState:"
	    << " " << armDerivedStateMsg->jointAngle0
	    << " " << armDerivedStateMsg->jointAngle1
	    << " " << armDerivedStateMsg->jointAngle2 << endl;
    logFile << "bodDerivedState:"
	    << " " << bodDerivedStateMsg->actLeftSteerDist
	    << " " << bodDerivedStateMsg->actRightSteerDist
	    << " " << bodDerivedStateMsg->actWheelVelocity[0]
	    << " " << bodDerivedStateMsg->actWheelVelocity[1]
	    << " " << bodDerivedStateMsg->actWheelVelocity[2]
	    << " " << bodDerivedStateMsg->actWheelVelocity[3]
	    << " " << bodDerivedStateMsg->servoState[0]
	    << " " << bodDerivedStateMsg->servoState[1]
	    << " " << bodDerivedStateMsg->brakeState[0]
	    << " " << bodDerivedStateMsg->brakeState[1]
	    << " " << bodDerivedStateMsg->actWheelCurrent[0]
	    << " " << bodDerivedStateMsg->actWheelCurrent[1]
	    << " " << bodDerivedStateMsg->actWheelCurrent[2]
	    << " " << bodDerivedStateMsg->actWheelCurrent[3]
	    << " " << bodDerivedStateMsg->actLeftSteerCurrent
	    << " " << bodDerivedStateMsg->actRightSteerCurrent
	    << " " << bodDerivedStateMsg->bogieAngle << endl;
    logFile << "dbNotify:" 
	    << " " << dbNotifyMsg->function << endl;
    logFile << "gpsDerivedState:"
	    << " " << gpsDerivedStateMsg->msecOfGPSWeek
	    << " " << gpsDerivedStateMsg->GPSWeek
	    << " " << gpsDerivedStateMsg->numSVSTracked
	    << " " << gpsDerivedStateMsg->numSVSVisible
	    << " " << gpsDerivedStateMsg->userDatumNorthOrX
	    << " " << gpsDerivedStateMsg->userDatumEastOrY
	    << " " << gpsDerivedStateMsg->userDatumUporZ
	    << " " << gpsDerivedStateMsg->velocityFlags
	    << " " << gpsDerivedStateMsg->horizVelocity
	    << " " << gpsDerivedStateMsg->heading
	    << " " << gpsDerivedStateMsg->positionRMSError
	    << " " << gpsDerivedStateMsg->positionDOP
	    << " " << gpsDerivedStateMsg->sigmaEast
	    << " " << gpsDerivedStateMsg->sigmaNorth
	    << " " << gpsDerivedStateMsg->eastNorthCovar
	    << " " << gpsDerivedStateMsg->sigmaUp
	    << " " << gpsDerivedStateMsg->sigmaOrientation
	    << " " << gpsDerivedStateMsg->unitVariance
	    << " " << gpsDerivedStateMsg->numEpochs << endl;
    logFile << "hiResDerivedState:"
	    << " " << hiResDerivedStateMsg->pan
	    << " " << hiResDerivedStateMsg->tilt
	    << " " << hiResDerivedStateMsg->FOV
	    << " " << hiResDerivedStateMsg->focalLength << endl;
    logFile << "kvhDerivedState:"
	    << " " << kvhDerivedStateMsg->pitch
	    << " " << kvhDerivedStateMsg->roll
	    << " " << kvhDerivedStateMsg->magneticAzimuth << endl;
    logFile << "laserDerivedState:"
	    << " " << laserDerivedStateMsg->laserHeight
	    << " " << laserDerivedStateMsg->laserTilt;
    for(int i=0; i < 180; i++) {
      logFile << " " << laserDerivedStateMsg->rangeMap[i];
    }
    logFile << " " << laserDerivedStateMsg->x
	    << " " << laserDerivedStateMsg->y
	    << " " << laserDerivedStateMsg->z
	    << " " << laserDerivedStateMsg->yaw
	    << " " << laserDerivedStateMsg->pitch
	    << " " << laserDerivedStateMsg->roll << endl;
    logFile << "move:"
	    << " " << moveMsg->radius
	    << " " << moveMsg->pointTurnFlag
	    << " " << moveMsg->turnSpeed
	    << " " << moveMsg->turnDistance
	    << " " << moveMsg->translateSpeed
	    << " " << moveMsg->translateDistance << endl;
    logFile << "posDerivedState:"
	    << " " << posDerivedStateMsg->posWest 
	    << " " << posDerivedStateMsg->posNorth
	    << " " << posDerivedStateMsg->posUp
	    << " " << posDerivedStateMsg->rotX
	    << " " << posDerivedStateMsg->rotY
	    << " " << posDerivedStateMsg->rotZ
	    << " " << posDerivedStateMsg->posNorthDot
	    << " " << posDerivedStateMsg->posWestDot
	    << " " << posDerivedStateMsg->deltaUpDot
	    << " " << posDerivedStateMsg->rotZDot   // NOTE: _Left steering position in mm_
	    << " " << posDerivedStateMsg->rotYDot   // _Right steering position in mm_
	    << " " << posDerivedStateMsg->rotXDot << endl;
    logFile << "rtAmpState:" 
	    << " " << (int)rtAmpStateMsg->rtAmpEnables
	    << " " << (int)rtAmpStateMsg->rtAmpFaults
	    << " " << (int)rtAmpStateMsg->rtCommand << endl;
    logFile << "rtControlState:" 
	    << " " << (int)rtControlStateMsg->rtDrivingMode
	    << " " << (int)rtControlStateMsg->rtCommand << endl;
    logFile << "rtEmergencySignals:" 
	    << " " << (int)rtEmergencySignalsMsg->rtEStop
	    << " " << (int)rtEmergencySignalsMsg->rtKillSwitch << endl;
    logFile << "sensManComplete:" 
	    << " " << sensManCompleteMsg->status 
	    << " " << sensManCompleteMsg->reqNum
	    << " " << sensManCompleteMsg->timeCost 
	    << " " << sensManCompleteMsg->energyCost
	    << " " << sensManCompleteMsg->maxDistanceTolerance
	    << " " << sensManCompleteMsg->minDistanceTolerance
	    << " " << sensManCompleteMsg->angularTolerance << endl;
    logFile << "targetAcqComplete:"
	    << " " << targetAcqCompleteMsg->status
	    << " " << targetAcqCompleteMsg->newTargetIDs[0] 
	    << " " << targetAcqCompleteMsg->newTargetIDs[targetAcqCompleteMsg->numTargets-1] // all IDs in between should be consecutive
	    << " " << targetAcqCompleteMsg->numTargets << endl;
    logFile << "weatherState:"
	    << " " << weatherStateMsg->insideTemperature
	    << " " << weatherStateMsg->outsideTemperature
	    << " " << weatherStateMsg->barometer
	    << " " << (int)weatherStateMsg->windSpeed
	    << " " << (int)weatherStateMsg->windGust
	    << " " << weatherStateMsg->WindChill
	    << " " << (int)weatherStateMsg->windDirection << endl;
    logFile.flush();
    
    NddsUtilitySleep(period);
  }

}

