/* FILE: targetAcqMain.h
   AUTHOR: Michael Wagner
   CREATED: Apr 19, 1999
   DESCRIPTION: Defines a few things for targetAcqMain.cpp
*/

#ifndef __TARGET_ACQ_MAIN_H__
#define __TARGET_ACQ_MAIN_H__

#include "ndds/NDDS.h"
#include "dbRecord.h"
#include "queue.h"
#include "targetAcqMsgs.h"
#include "acqDriverDef.h"
#include "sensorMsgs.h"

// Global NDDS client/server definitions
#define TARGET_ACQ_SERVER_STRENGTH 10.0f
#ifndef SENSOR_MIN_WAIT_TIME
#define SENSOR_MIN_WAIT_TIME 0.0f
#endif
#ifndef SENSOR_MAX_WAIT_TIME
#define SENSOR_MAX_WAIT_TIME 120.0f
#endif
#define DB_MIN_WAIT_TIME 0.0f
#define DB_MAX_WAIT_TIME 5.0f

// Global NDDS publisher definitions
#define TARGET_ACQ_COMPLETE_PERSISTANCE 15.0f
#define TARGET_ACQ_COMPLETE_STRENGTH 10.0f

// Global NDDS subscriber definitions
#define SENSOR_REG_DEADLINE 10.0f
#define SENSOR_REG_MIN_SEPARATION 0.0f 
#define TELEMETRY_DEADLINE 10.0f
#define TELEMETRY_MIN_SEPARATION 0.0f 

typedef struct {
  targetAcq *acq;
  TARGET_ACQ_FUNCTION *driverFunction;
} targetAcqServiceParam;

typedef struct {
  DGPS *currPosition;
  pose *currPose;
} telemetryParam;

// Service routines
RTIBool targetAcqServiceRtn(NDDSObjectInstance reply,
			    NDDSObjectInstance request,
			    void *userData);

// NDDS server and client setup functions.
void sensorClientSetup(int sensorNum, char *sensorID, NDDSClient *client);
void dbClientSetup(NDDSClient *client);
void targetAcqServerSetup(targetAcq *sensorManager, queue<targetAcqRequest *> *clientReqQ);

// NDDS subscription functions
RTIBool sensorRegCallback(NDDSRecvInfo *issue);

// Other functions.
void publishComplete(NDDSPublication pub, targetAcqComplete *msg, int status, int reqNum, acqResults *results);

#endif /* __TARGET_ACQ_MAIN_H__ */


