/* FILE: targetAcq.h
   AUTHOR: Michael Wagner
   CREATED: Jun 1 1999
   DESCRIPTION: 
*/

#ifndef __TARGET_ACQ_H__
#define __TARGET_ACQ_H__

#include "acqDriver.h"
#include "targetAcqDef.h"
#include "acqDriverDef.h"
#include "sensorDef.h"

// TBD: Maybe have this and sensMan stem from one common class??

class targetAcq {
 public:
  targetAcq();
  ~targetAcq();
  
  // Methods dealing with drivers ("logical sensors")
  TARGET_ACQ_STATUS initDriver(acqDriver *newDriver, int *driverNum); 
  TARGET_ACQ_STATUS deleteDriver(int driverNum);  
  acqDriver *getDriver(int driverNum);
  int getNumDrivers();
  int isValidDriver(int driverNum);

  // Methods dealing with sensors ("physical sensors")
  TARGET_ACQ_STATUS addSensor(char *sensorID, SENSOR_STATUS mode, int *sensorNum);
  TARGET_ACQ_STATUS deleteSensor(int sensorNum);

 private:
  acqDriver *drivers[TARGET_ACQ_MAX_DRIVERS];
  int numDrivers;
  
  char *sensorIDs[TARGET_ACQ_MAX_SENSORS];
  int numSensors;
  SENSOR_STATUS sensorModes[TARGET_ACQ_MAX_SENSORS];
};

#endif /* __TARGET_ACQ_H__ */

