#include <iostream.h>
#include <stdio.h>
#include <fstream.h>

#include "targetAcq.h"
#include "targetAcqDef.h"

targetAcq::targetAcq() {
  // Initialize all driver pointers to NULL
  for(int i=0; i < TARGET_ACQ_MAX_DRIVERS; i++) {
    drivers[i] = NULL;
  }

  for(int i=0; i < TARGET_ACQ_MAX_SENSORS; i++) {
    sensorIDs[i] = NULL;
  }

  numDrivers = 0;
  numSensors = 0;
}

targetAcq::~targetAcq() {
  // Destroy all driver objects in array
  for(int i=0; i < TARGET_ACQ_MAX_DRIVERS; i++) {
    if (drivers[i] != NULL) {
      delete(drivers[i]);
    }
  }
  
  for(int i=0; i < TARGET_ACQ_MAX_SENSORS; i++) {
    delete(sensorIDs[i]);
  }

  numDrivers = 0;
  numSensors = 0;
}

TARGET_ACQ_STATUS targetAcq::initDriver(acqDriver *newDriver, int *driverNum) {
  if(numDrivers < TARGET_ACQ_MAX_DRIVERS-1) {
    drivers[numDrivers] = newDriver;
    cerr << "[targetAcq] Initialized new driver \"" << drivers[numDrivers]->driverID << "\" as driver #" << numDrivers << endl;
    numDrivers++;
    *driverNum = numDrivers;
    return(TARGET_ACQ_SUCCESSFUL);
  } else {
    return(TARGET_ACQ_FAILED);
  }
}

TARGET_ACQ_STATUS targetAcq::deleteDriver(int driverNum) {
  if((driverNum >= 0) && (driverNum < TARGET_ACQ_MAX_DRIVERS)) {
    delete drivers[driverNum];
    numDrivers--;
    return(TARGET_ACQ_SUCCESSFUL);
  } else {
    return(TARGET_ACQ_FAILED);
  }
}


acqDriver *targetAcq::getDriver(int driverNum) {
  if((driverNum >= 0) && (driverNum < TARGET_ACQ_MAX_DRIVERS) && 
     (drivers[driverNum] != NULL)) {
    return(drivers[driverNum]);
  } else {
    return(NULL);
  }
}

int targetAcq::getNumDrivers() {
  return numDrivers;
}

int targetAcq::isValidDriver(int driverNum) {
  // TBD: Check that all the sensors that the driver depends on have been
  // registered. This will require a way to keep track of what drivers need
  // what sensors.
  
  return(driverNum == 0);
}

TARGET_ACQ_STATUS targetAcq::addSensor(char *sensorID, SENSOR_STATUS mode, int *sensorNum) {
  if(numSensors < TARGET_ACQ_MAX_SENSORS-1) {
    // Check to see if sensor has already been added.
    for(int i=0; i < numSensors; i++) {
      if(strcmp(sensorID, sensorIDs[i]) == 0) {
	return(TARGET_ACQ_FAILED);
      }
    }
    sensorIDs[numSensors] = new char[strlen(sensorID)];
    sensorModes[numSensors] = mode;
    strcpy(sensorIDs[numSensors], sensorID);
    numSensors++;
    *sensorNum = numSensors;
    return(TARGET_ACQ_SUCCESSFUL);
  } else {
    return(TARGET_ACQ_FAILED);
  }
}

TARGET_ACQ_STATUS targetAcq::deleteSensor(int sensorNum) {
  if((sensorNum >= 0) && (sensorNum < TARGET_ACQ_MAX_SENSORS) && (sensorIDs[sensorNum] != NULL)) {
    sensorIDs[sensorNum] = NULL;
    numSensors--;
    return(TARGET_ACQ_SUCCESSFUL);
  } else {
    return(TARGET_ACQ_FAILED);
  }
}

