/* FILE: ppmRockSeg.h
   CREATED: May 20, 1999
   AUTHOR: Michael Wagner
   DESCRIPTION: This file describes a rock on ice segmentation algorithm
     that uses Fisher's linear discriminant on PPM images. 
*/

#ifndef __PPM_ROCK_SEG_H__
#define __PPM_ROCK_SEG_H__

#include "ppm.h"
#include "acqDriverDef.h"
#include "dbRecord.h"
#include "queue.h"
#include "telemetryMsgs.h"

#define MIN_COL 10
#define MAX_COL numCols

#define DEFAULT_TOP_BOX_SIZE 8
#define DEFAULT_BOTTOM_BOX_SIZE 34
#define DEFAULT_TOP_PIX_SIZE 3
#define DEFAULT_BOTTOM_PIX_SIZE 8
#define LINERATIO 1.5f

// Definitions for Kim's threshhold
#define MAX_STDDEV_RATIO 35
#define CBLUE 2.5f
#define CGREEN 3.1f
#define PERCENTAGE 0.8f
#define TARGET_ADJ_BOUNDARY 3
#define TARGET_LINE_RATIO 1.5
#define TARGET_MIN_PIXELS 5

typedef enum {
  R,
  G,
  B,
  R_G,
  R_B,
  G_R,
  G_B,
  B_R,
  B_G
} IMAGE_WEIGHT;

class imageWeightVector {
 public:
  float w[9]; // R, G, B, R/G, R/B, G/R, G/B, B/R, B/G
  float threshhold;
};

class ppmRockSeg : public ppm {
 public:
  ppmRockSeg();
  ppmRockSeg(laserDerivedState *laser);
  ppmRockSeg(int topBoxSize, int bottomBoxSize, int topPixSize, int bottomPixSize, laserDerivedState *laser);

  ~ppmRockSeg() {
    delete(lastWeightVector);
  }

  int fldThreshhold(DGPS *robotPosition, pose *robotPose, 
		    int minRow, int maxRow, 
		    acqResults *results); /* Uses lastWeightVector to threshhold the image,
					     then uses Fisher's Linear Discriminant to create
					     a new vector. */
  int kimThreshhold(DGPS *robotPosition, pose *robotPose, 
		    int minRow, int maxRow, 
		    acqResults *results); /* Uses Kim's algorithm. */
  int redThreshhold(DGPS *robotPosition, pose *robotPose, 
		    int minRow, int maxRow, 
		    acqResults *results); /* Picks out red objects.
					     1 on success, 0 on failure. */
  
 private:
  int topBoxSize, bottomBoxSize, topPixSize, bottomPixSize;
  laserDerivedState *laser;

  imageWeightVector *lastWeightVector;

  float sqr(int a);
  void addToLists(int row, int col, target_type* target);
}; 


#endif /* __PPM_ROCK_SEG_H__ */
