/***************************************************************************
 * Header file for gps_calc.c (get_gps function)
 *
 * Written by Stewart Moorhead Oct 5, 1998.
 ***************************************************************************/

#ifndef _GPS_CALC_H
#define _GPS_CALC_H

#include "telemetryMsgs.h"

#ifndef PI
#define PI (3.14159)
#endif

#define DEG_TO_RAD(d)   ((d) * PI / 180.0)

#define X 0
#define Y 1
#define Z 2

void get_gps(float pan, float tilt, int row, int col, float f,
             float pitch, float roll, float yaw, float height,
             float *x, float *y, float *z, float *d);
float ground_height(laserDerivedState *laser, int start, int end);
void get_laser_start_end(float x, float y, float width, 
                         laserDerivedState *laser, int *start, int *end);

#endif

