/* FILE: acqHiResDriver.h
   CREATED: May 22, 1999
   AUTHOR: Michael Wagner
   DESCRIPTION: This file describes a target acqusition driver for Nomad's
     high resolution pan/tilt camera.
*/

#ifndef __ACQ_HI_RES_DRIVER_H__
#define __ACQ_HI_RES_DRIVER_H__

#include "acqDriver.h"
#include "ppmRockSeg.h"
#include "sensorMsgs.h"
#include "telemetryMsgs.h"

// TBD: Put these in a centralized place.
#define HI_RES_DRIVER_ID "acqHiResDriver"
#define HI_RES_SENSOR_ID "hiResSensor"

// Global NDDS client/server definitions
#ifndef SENSOR_MIN_WAIT_TIME
#define SENSOR_MIN_WAIT_TIME 0.5f
#endif
#ifndef SENSOR_MAX_WAIT_TIME
#define SENSOR_MAX_WAIT_TIME 4.0f
#endif
#ifndef TELEMETRY_DEADLINE
#define TELEMETRY_DEADLINE 10.0f
#endif
#ifndef TELEMETRY_MIN_SEPARATION
#define TELEMETRY_MIN_SEPARATION 0.0f 
#endif

class acqHiResDriver : public acqDriver {
 public:
  acqHiResDriver(DGPS *currPosition, pose *currPose);
  ~acqHiResDriver();

  // Implementing the acqDriver interface.
  int setupAcq();
  int examine(acqResults *);
  
 private:
  DGPS *currPosition;
  pose *currPose;
  ppmRockSeg *image;
  void sensorClientSetup();
  NDDSClient client;
  NDDSClientReplyStatus clientStatus;
  sensorRequest *sensorRequestMsg;
  sensorReply *sensorReplyMsg;
  laserDerivedState *laserDerivedStateMsg;
  NDDSSubscription laserSub;

  int startRow, stopRow; // The beginning and ending rows for segmentation
}; 

#endif /* __ACQ_HI_RES_DRIVER_H__ */
