/* FILE: acqDriverDef.h
   CREATED: May 24, 1999
   AUTHOR: Michael Wagner
   DESCRIPTION: This file defines a few things for the target acquisition 
     drivers.
*/

#ifndef __ACQ_DRIVER_DEF_H__
#define __ACQ_DRIVER_DEF_H__

#include "sensorDef.h"
#include "dbRecord.h"

#define ACQ_DRIVER_MAX_ID_LENGTH SENSOR_MAX_ID_LENGTH
#define MAX_TARGETS_IN_ACQ_DATA 20

typedef struct {
  int row, column;
} pixel_type;

typedef struct list_t{
  pixel_type data;
  struct list_t* next;
} list;

typedef struct {
  int targetnum;
  list *leafs;
  int totalpix;
  float maxdist;
  pixel_type midpt;
  pixel_type firstPixel;
  pixel_type lastPixel;
} target_type;

struct acqResults {
  DGPS targetPos[MAX_TARGETS_IN_ACQ_DATA];
  target_type targets[MAX_TARGETS_IN_ACQ_DATA];
  int numTargets;
};

#endif /* __ACQ_DRIVER_DEF_H__ */
