/* FILE: acqDriver.h
   AUTHOR: Michael Wagner
   CREATED: May 20, 1999
   DESCRIPTION: This file defines the virtual class
     acqDriver, to be extended by any target acq
     device driver.
*/

#ifndef __ACQ_DRIVER_H__
#define __ACQ_DRIVER_H__

#include "dbRecord.h"
#include "acqDriverDef.h"
#include "targetAcqDef.h"

class acqDriver {
 public:
  acqDriver(DGPS *currPosition, pose *currPose) {};
  ~acqDriver() {};

  // The acqDriver interface
  virtual int setupAcq() = 0;
  virtual int examine(acqResults *) = 0;

  char driverID[ACQ_DRIVER_MAX_ID_LENGTH];
};
  

#endif /* __ACQ_DRIVER_H__ */
