#ifndef PI
#define PI                    3.14159265358979323846264338
#endif

#define TWOPI                (2.0*PI)
#define ZERO                  0.0
#define ONE                   1.0

#define EARTHSMA         149597892.0      /* 1 AU [km]                      */
#define EARTHRADIUS           6378.137    /* equatorial radius [km]         */
#define JULCENT              36525.0      /* mean solar days / jcy          */
#define JULDAT2000         2451545.0      /* Julian date of 2000.0          */
#define MOONRADIUS            1738.0      /* equatorial radius [km]         */
#define MOONROT                 27.322    /* rotation period [days]         */
#define EEQ_ECL                  0.40910416 /* angle between earth equator
                                             and ecliptic planes [radians]  
					     for Jdate = 2449717.5          */
#define EEDate                2449717.5   /* Date of given EEQ_ECL          */
#define EEChange            0.0000000063  /* change in EEQ_ECL per day      */
#define ECL_LEQ                0.0269202  /* angle between ecliptic and
                                             lunar equator planes [radians] */
#define OMEGAP             0.392514199    /* position of lunar orbit-ecliptic
					     node at OMPDate                */
#define OMPDate            2450082.5      /* Date of given OMEGAP           */
#define OMPChange          0.0009242176   /* change in OMEGAP per day       */
#define TOMEGA0            2449757.59     /* Julian date when lunar meridian*/
                                          /* is at lunar equator ascending  */
                                          /* node on ecliptic               */

double absol(double vector[3]);
void SunMoonPos(double Jdate, double* sunRA, double* sunDec, double* sunDist,
                double* moonRA, double* moonDec, double* moonDist);
