/* FILE: sensorMain.h
   AUTHOR: Michael Wagner
   CREATED: Apr 15, 1999
   DESCRIPTION: This file defines a few things that sensorMain.cpp needs.
     These things should be defined differently depending on what driver
     is being compiled!
*/

#ifndef __SENSOR_MAIN_H__
#define __SENSOR_MAIN_H__

#include "currentSensor.h"

#define SENSOR_REG_PERSISTANCE 15.0f
#define SENSOR_REG_STRENGTH 10.0f

#define SENSOR_NAME hiResSensor
#define SENSOR_NAME_STR "hiResSensor"
#define SENSOR_CONSTRUCTOR(_sensorID_) hiResSensor(_sensorID_, "/usr/nomad/data/HiRes/", new frameGrabberConfig(PXC_SLEEP_TIME, PXC_BRIGHTNESS, PXC_CONTRAST, PXC_HUE, PXC_SAT_U, PXC_SAT_V), new dgpsVector(PTU_X, PTU_Y, PTU_Z - DGPS_SENSOR_Z))

//#define SENSOR_NAME armSensor
//#define SENSOR_NAME_STR "armSensor"
//#define SENSOR_CONSTRUCTOR(_sensorID_) armSensor(_sensorID_)

#endif /* __SENSOR_MAIN_H__ */
