/* FILE: sensorDef.h
   CREATED: 4/12/99
   AUTHOR: Michael Wagner
   
   DESCRIPTION: This file defines types used by the sensors.
 */

#ifndef __SENSOR_DEF_H__
#define __SENSOR_DEF_H__

#include "dbRecordDef.h"

#define SENSOR_MAX_FILENAME_LENGTH MAX_DATA_FILENAME_LENGTH
#define SENSOR_MAX_ID_LENGTH 128
#define SENSOR_MAX_READINGS MAX_SENSOR_READINGS

/* This enum describes the various return statuses of sensor driver
   operations. */
typedef enum {
  SENSOR_OK,                      // No error
  SENSOR_OFF_LINE,                // Sensor was not able to start up properly. Before attempting anything, startup should be again called
  SENSOR_BUSY,                    // Sensor still pending on something
  SENSOR_MALFUNCTION,             // Something internally wrong with the sensor (see extendedStatus for more info) 
  SENSOR_DEPLOYMENT_FAILURE,      // Sensor is working properly, but cannot deploy to the given target
  SENSOR_OUT_OF_WORKSPACE,        // A special type of deployment failure -- the sensor is working fine but the target is out of its workspage
  SENSOR_DAQ_FAILURE,             // Sensor is working properly, but cannot acquire data on the given target
  SENSOR_NEEDS_CALIBRATION        // Sensor must be calibrated before next operation
} SENSOR_STATUS;


/* This enum describes the various functions the sensor manager can give
   to a sensor driver. */
typedef enum {
  SENSOR_GET_STATUS_FUNCTION,
  SENSOR_ACQUIRE_DATA_FUNCTION,
  SENSOR_TARGET_ACQ_FUNCTION,
  SENSOR_SHUTDOWN_FUNCTION,
  SENSOR_STARTUP_FUNCTION,
  SENSOR_DEPLOY_FUNCTION,
  SENSOR_UNDEPLOY_FUNCTION,
  SENSOR_DIAGNOSTIC_FUNCTION,
  SENSOR_CALIBRATE_FUNCTION,
  SENSOR_TIME_COST_REQUEST_FUNCTION,
  SENSOR_ENERGY_COST_REQUEST_FUNCTION,
  SENSOR_STORAGE_COST_REQUEST_FUNCTION,
  SENSOR_WORKSPACE_REQUEST_FUNCTION,
  SENSOR_DEBUG_MODE_FUNCTION = 1023      /* No function can map to an integer 
					    higher than 1023. 1024 and above
					    are reserved for special sensor
					    functions. See the sensorNameDef.h
					    files for these enumerations. */
} SENSOR_FUNCTION;

#endif /* __SENSOR_DEF_H__ */
