/* FILE:    metalDetectorSensor.h
   AUTHOR:  Michael Wagner
   CREATED: Aug 26, 1999

   DESCRIPTION: This file defines the metal detector sensor 
     driver class, metalDetectorSensor. This class is inhereted from 
     the virtual class sensor.h
*/

#ifndef __METAL_DETECTOR_SENSOR_H__
#define __METAL_DETECTOR_SENSOR_H__

#include "sensor.h"
#include "daqCard.h"
#include "metalDetectorSensorDef.h"

class metalDetectorSensor : public sensor {
 public:
  metalDetectorSensor(char *sensorID, char *DAQ_SaveFileNameBase, float daqPeriod); /* The constructor should simply instantiate 
										      objects and set class variables. */
  ~metalDetectorSensor();                                            /* The destructor should delete objects in 
									the sensor driver class. Deleting the 
									objects in this class should automatically 
									call their respective uninit functions, to 
									close serial ports and such. */
  
  // Implementing the sensor interface.
  sensorReply *startup(sensorRequest *req);         /* The startup function should initialize all 
						       subcomponents, and prepare the sensor for deployment. */
  sensorReply *calibration(sensorRequest *req);     /* The calibration function should be used to update 
						       internal state variables with correct values. */
  sensorReply *deployment(sensorRequest *req);      /* The deployment function should deploy the sensor to the 
						       target coordinates (request->targetPosition), given a 
						       current robot location and pose (request->robotPosition). */ 
  sensorReply *unDeployment(sensorRequest *req);    /* The unDeployment function should servo the sensor back 
						       to its startup state. */
  sensorReply *dataAcquisition(sensorRequest *req); /* The dataAcqusition function should simply capture data, 
						       calculate the appropriate file name in which to save this 
						       new data, and save it. */
  sensorReply *shutdown(sensorRequest *req);        /* The shutdown function should uninitialize the sensor but 
						       not delete any state information or internal variables. */ 
  sensorReply *diagnostic(sensorRequest *req);      /* The diagnostic function should run the sensor through a
						       number of tests to search for errors, and return the most
						       important error to the user. */
  sensorReply *toggleDebug(sensorRequest *req);     /* Switches sensor to debug mode. */

 private:
  char *DAQ_SaveFileNameBase; 
  int debugMode;
  daqCard daq;
  int writeFile(char *filename, float *dataBuff, float *timeBuff);
  float currentReading[METAL_DETECTOR_NUM_READINGS];
  float currentTimeBuff[METAL_DETECTOR_NUM_READINGS];
  float daqPeriod; // The time between readings in seconds
};

#endif /* __METAL_DETECTOR_SENSOR_H__ */

  



