#include <iostream.h>
#include <stdlib.h>
#include "daqCard.h"
#include "daqCardDef.h"

int main(int argc, char *argv[]) {
  if(argc != 2) {
    cerr << "usage: testDAQ channel\n";
    return(-1);
  }
  
  daqCard daq;
  float f;
  float fBuff[100];
  float *timeBuff = new float[100];

  daq.open();

  if(daq.setChannel(atoi(argv[1])) != DAQ_CARD_OK) {
    cout << "Reading a single value from channel " << atoi(argv[1]) << " ... ";
    daq >> f;
    cout << f << " done!" << endl;
    cout << "Reading 50 floating point numbers from channel " << atoi(argv[1]) << ":" << endl;
    if(daq.read(fBuff, 50) == DAQ_CARD_OK) {
      for(int i=0; i < 50; i++) {
	cout << "\t" << i << ": " << fBuff[i] << endl;
      }
      cout << "Reading 10 floating point numbers from channel " << atoi(argv[1]) << " with a period of 2 sec:" << endl;
      if(daq.read(fBuff, 10, 2.0, timeBuff) == DAQ_CARD_OK) {
	if(timeBuff == NULL) { cerr << "failed time measurement!" << endl; }
	for(int i=0; i < 10; i++) {
	  cout << "\t" << i << ": " << fBuff[i] << ", time = " << timeBuff[i] << endl;
	}
      } else {
	cerr << "Failed daq.read with period!" << endl;
	daq.close();
	return(-1);
      }
    } else {
      cerr << "Failed daq.read!" << endl;
      daq.close();
      return(-1);
    }
    daq.close();
    return(0);
  } else {
    cerr << "Invalid channel! Must be 0 to " << DAQ_CARD_NUM_CHANNELS-1 << endl;
    daq.close();
    return(-1);
  }
}
