/* AUTHOR: Michael Wagner
   DATE:   Aug 26, 1999
   DESCRIPTION: This file describes the daqCard class, which provides functionality
     from the NI-DAQ series E card that is on meteorite.frc. This class uses code
     from the National Instruments E-series BETA DAQ Driver v0.8.1. For more info,
     check out www.natinst.com/linux
*/

#ifndef __DAQ_CARD_H__
#define __DAQ_CARD_H__

#include <iostream.h>
#include "daqCardDef.h"

class daqCard : public ostream {
 public:
  daqCard();

  int open();   // Returns DAQ_CARD_STATUS (see daqCardDef.h)
  void close();
  int setChannel(int channel); /* The user must set a "current" channel to use
				  the I/O methods below, returns DAQ_CARD_STATUS. */

  /* Read single datum into various types of variables. These are not the
     best way to read data into an array, see the 'read' methods below. 
     These operator methods return 1 on success, 0 on failure. */ 

  ostream &operator>>(float &f);
  ostream &operator>>(double &d);
  ostream &operator>>(int &i);
  ostream &operator>>(long &l);
  ostream &operator>>(short &s);

  /* Read a bunch of data into various types of variables, return
     DAQ_CARD_STATUS. 'num' specifies the number of datum, not the 
     number of bytes. */
  int read(float *f, int num);
  int read(double *d, int num);
  int read(int *i, int num);
  int read(long *l, int num);
  int read(short *s, int num);

  /* These functions work like above, except you pass a rough
     period to specify how often data will be read. daqPeriod is in
     seconds. TBD: Figure out how to make these periods more strictly followed! 
     Despite this, execTime is returned as an array recording the number of seconds 
     each operation took. */
  int read(float *f, int num, float daqPeriod, float *execTime);
  int read(double *d, int num, float daqPeriod, float *execTime);
  int read(int *i, int num, float daqPeriod, float *execTime);
  int read(long *l, int num, float daqPeriod, float *execTime);
  int read(short *s, int num, float daqPeriod, float *execTime);

 private:
  int fd;
  int channel;
};

#endif /* __DAQ_CARD_H__ */
