/* FILE:    ptuAngle.h
   AUTHOR:  Michael Wagner
   CREATED: Apr 7, 1999

   DESCRIPTION: Defines the ptuAngle class, which encapsulates
     pan and tilt angle data. This class is used extensively in 
     the hiResPtu class.
*/

#ifndef __PTU_ANGLE_H__
#define __PTU_ANGLE_H__

class ptuAngle {
 public:
  ptuAngle(double p, double t);

  void copy(ptuAngle *angle); // Does nothing if angle == NULL.

  double pan, tilt; /* pan is defined as angle in x-y plane,
		       tilt is angle in r-z plane (r =<x,y,0>)
		       Positive angles are to the right and up. 
		       Angles are assumed to be in radians. */
};

#endif // __PTU_ANGLE_H__

