/* FILE:    dgpsVector.h
   AUTHOR:  Michael Wagner
   CREATED: Apr 7, 1999

   DESCRIPTION: Defines the dgpsVector class, which right now just
     encapsulates a 3D vector. This is used as DGPS coordinates by
     the hiResPtu class, so the values are generally in meters.
*/

#ifndef __DGPS_VECTOR_H__
#define __DGPS_VECTOR_H__

class dgpsVector {
 public:
  dgpsVector(double x0, double y0, double z0);
  dgpsVector() {}
  ~dgpsVector() {}

  void rotate(double roll, double pitch, double yaw);

  double distanceTo(dgpsVector *b);
  
  double x, y, z;  // Assumed to be in meters.
};

#endif // __DGPS_VECTOR_H__

