/* FILE:    dgpsVector.cpp
   AUTHOR:  Michael Wagner
   CREATED: Apr 7, 1999

   DESCRIPTION: Implements the dgpsVector class, which right now just
     encapsulates a 3D vector. This is used as DGPS coordinates by
     the hiResPtu class.
*/

#include <iostream.h>
#include "dgpsVector.h"

dgpsVector::dgpsVector(double x0, double y0, double z0) {
  x = x0;
  y = y0;
  z = z0;
}

void dgpsVector::rotate(double roll, double pitch, double yaw) {
  double ca, sa,cb,sb,cg,sg;
  double nx,ny,nz;
  ca = cos(yaw);
  sa = sin(yaw);
  cb= cos(pitch);
  sb= sin(pitch);
  cg = cos(roll);
  sg= sin(roll);
  
  nx = ca*cb*x + (ca*sb*sg - sa*cg)*y + (ca*sb*cg + sa*sg)*z;
  ny = sa*cb*x + (sa*sb*sg + ca*cg)*y + (sa*sb*cg - ca*sg)*z;
  nz = -sb* x + (cb*sg)*y + (cb*cg)*z;
  this->x=nx;
  this->y=ny;
  this->z=nz;
}

double dgpsVector::distanceTo(dgpsVector *b) { 
  return sqrt((x-b->x)*(x-b->x) + (y-b->y)*(y-b->y) + (z-b->z)*(z-b->z));
};
