/* FILE:    lensController.h
   AUTHOR:  Michael Wagner
   CREATED: Apr 8, 1999

   DESCRIPTION: Defines the lensController class, which is used
     to use Mike Montemerlo's Motorola HC16... microcontroller
     over a serial port. This device controls a Fujinon 
     H14x10.5B-Y41 lens.
*/

#ifndef __LENS_CONTROLLER_H__
#define __LENS_CONTROLLER_H__

#include "linuxser.h"
#include <fstream.h>

#define LENS_OK 0
#define LENS_CONTROLLER_SERIAL_READ_FAIL (-1)
#define LENS_CONTROLLER_CMD_OUT_OF_BOUNDS (-2)
#define LENS_CONTROLLER_NOT_INITIALIZED (-3) /* Returned when init not yet 
						called. Intentionally kept
					        equal to 
						PTU_NOT_INITIALIZED. */
#define LENS_FAIL (-4) /* Returned when a command fails for another reason. */

#define ZOOM_IN_FULL 39
#define ZOOM_OUT_FULL 220
#define FOCUS_OUT_FULL 26
#define FOCUS_IN_FULL 235

#define TIMEOUT_TRIES 100
#define LENS_ACCURACY 4

class lensController {
 public:
  lensController();
  ~lensController();
  
  int init(int serialPortNum); /* Returns LENS_OK on success, 
				  LENS_CONTROLLER_NOT_INITIALIZED on failure */
  void uninit(); /* Closes communications with serial port. */

  int setZoomAbs(unsigned char zoomVal);       // These functions return LENS_OK on success,
  int setZoomAbsBlock(unsigned char zoomVal);  // other things on failure.
  int setZoomRel(char zoomVal);
  int setZoomRelBlock(char zoomVal); 
  int setFocusAbs(unsigned char zoomVal);
  int setFocusAbsBlock(unsigned char zoomVal);
  int setFocusRel(char zoomVal);
  int setFocusRelBlock(char zoomVal);

  int getHardwareZoom();   // Return ints so that errors
  int getHardwareFocus();  // or data can be sent.

  int getLastCmdZoom();    // Return ints so that errors
  int getLastCmdFocus();   // or data can be sent.

 private:
  unsigned char lastCmdZoom;
  unsigned char lastCmdFocus;
  int initOccurred;
  portstream_fd serialStream;
  char portName[256];

  int blockOnZoom(int zoomVal);   // Return LENS_OK on success, other things on failure.
  int blockOnFocus(int focusVal); 

};

/* These functions are static, and are based on the Fujinon H14x10.5B-Y41 lens. */
float focalLength(unsigned char zoomVal); /* Calculates the focal length (in mm) given a zoom
				      value byte. */
float fieldOfView(unsigned char zoomVal); /* Calculates the field of view (in rad) given a zoom value byte. */
unsigned char fovToZoomByte(float fieldOfView); /* Inverse of fieldOfView(unsigned char) */
//float focusToDistance(unsigned char focusVal);   /* Calculates the distance of an object based on its ideal focus. */
//unsigned char distanceToFocusByte(float distance); /* Inverse of focusToDistance(unsigned char) */

#endif // __LENS_CONTROLLER_H__
