#ifndef __FUJINON_FOV_H__
#define __FUJINON_FOV_H__

#include "lensController.h"

/* To use this table, either search through the array for the right zoomVal, or
   at least for now, just add FOV_TABLE_OFFSET to the index (i.e. the zoom value
   at index 10 is 10 + FOV_TABLE_OFFSET = 49). */

typedef struct {
  unsigned int zoomVal;
  float FOV;
} FOV_Struct;

#define FOV_TABLE_OFFSET ZOOM_IN_FULL

FOV_Struct fujinonFOV_Table[ZOOM_OUT_FULL - ZOOM_IN_FULL + 1] = {
  {39,0.0326},
  {40,0.0328},
  {41,0.0330},
  {42,0.0332},
  {43,0.0333},
  {44,0.0335},
  {45,0.0337},
  {46,0.0339},
  {47,0.0340},
  {48,0.0342},
  {49,0.0344},
  {50,0.0346},
  {51,0.0347},
  {52,0.0349},
  {53,0.0351},
  {54,0.0353},
  {55,0.0356},
  {56,0.0358},
  {57,0.0360},
  {58,0.0361},
  {59,0.0363},
  {60,0.0365},
  {61,0.0368},
  {62,0.0370},
  {63,0.0372},
  {64,0.0374},
  {65,0.0377},
  {66,0.0379},
  {67,0.0380},
  {68,0.0382},
  {69,0.0386},
  {70,0.0387},
  {71,0.0389},
  {72,0.0393},
  {73,0.0394},
  {74,0.0398},
  {75,0.0400},
  {76,0.0403},
  {77,0.0405},
  {78,0.0408},
  {79,0.0410},
  {80,0.0414},
  {81,0.0415},
  {82,0.0419},
  {83,0.0421},
  {84,0.0424},
  {85,0.0428},
  {86,0.0429},
  {87,0.0433},
  {88,0.0435},
  {89,0.0438},
  {90,0.0442},
  {91,0.0445},
  {92,0.0449},
  {93,0.0450},
  {94,0.0454},
  {95,0.0457},
  {96,0.0461},
  {97,0.0464},
  {98,0.0468},
  {99,0.0471},
  {100,0.0475},
  {101,0.0478},
  {102,0.0482},
  {103,0.0485},
  {104,0.0489},
  {105,0.0492},
  {106,0.0497},
  {107,0.0501},
  {108,0.0504},
  {109,0.0508},
  {110,0.0513},
  {111,0.0517},
  {112,0.0522},
  {113,0.0525},
  {114,0.0531},
  {115,0.0534},
  {116,0.0539},
  {117,0.0543},
  {118,0.0548},
  {119,0.0553},
  {120,0.0559},
  {121,0.0562},
  {122,0.0567},
  {123,0.0572},
  {124,0.0578},
  {125,0.0583},
  {126,0.0588},
  {127,0.0595},
  {128,0.0600},
  {129,0.0606},
  {130,0.0613},
  {131,0.0618},
  {132,0.0625},
  {133,0.0630},
  {134,0.0637},
  {135,0.0644},
  {136,0.0649},
  {137,0.0656},
  {138,0.0663},
  {139,0.0670},
  {140,0.0677},
  {141,0.0684},
  {142,0.0693},
  {143,0.0700},
  {144,0.0707},
  {145,0.0716},
  {146,0.0724},
  {147,0.0731},
  {148,0.0740},
  {149,0.0749},
  {150,0.0757},
  {151,0.0768},
  {152,0.0777},
  {153,0.0785},
  {154,0.0796},
  {155,0.0806},
  {156,0.0817},
  {157,0.0827},
  {158,0.0838},
  {159,0.0848},
  {160,0.0860},
  {161,0.0873},
  {162,0.0885},
  {163,0.0897},
  {164,0.0909},
  {165,0.0923},
  {166,0.0937},
  {167,0.0951},
  {168,0.0965},
  {169,0.0979},
  {170,0.0995},
  {171,0.1011},
  {172,0.1026},
  {173,0.1044},
  {174,0.1061},
  {175,0.1079},
  {176,0.1098},
  {177,0.1117},
  {178,0.1136},
  {179,0.1157},
  {180,0.1180},
  {181,0.1201},
  {182,0.1223},
  {183,0.1248},
  {184,0.1274},
  {185,0.1299},
  {186,0.1326},
  {187,0.1354},
  {188,0.1384},
  {189,0.1414},
  {190,0.1447},
  {191,0.1480},
  {192,0.1515},
  {193,0.1552},
  {194,0.1592},
  {195,0.1632},
  {196,0.1674},
  {197,0.1719},
  {198,0.1768},
  {199,0.1817},
  {200,0.1871},
  {201,0.1927},
  {202,0.1988},
  {203,0.2051},
  {204,0.2119},
  {205,0.2192},
  {206,0.2269},
  {207,0.2353},
  {208,0.2443},
  {209,0.2539},
  {210,0.2646},
  {211,0.2759},
  {212,0.2883},
  {213,0.3019},
  {214,0.3168},
  {215,0.3332},
  {216,0.3515},
  {217,0.3718},
  {218,0.3947},
  {219,0.4203},
  {220,0.4494},
};

#endif /* __FUJINON_FOV_H__ */





