#ifndef __HI_RES_SENSOR_TELEMETRY_H__
#define __HI_RES_SENSOR_TELEMETRY_H__

#include <pthread.h>
#include "telemetryMsgs.h"

typedef enum {
  HI_RES_TELEMETRY_START,
  HI_RES_TELEMETRY_STOP
} HI_RES_TELEMETRY_STATE;

#define HI_RES_TELEMETRY_DEFAULT_PERIOD 2.0f /* sec */
#define HI_RES_TELEMETRY_PERSISTANCE 15.0f
#define HI_RES_TELEMETRY_STRENGTH 10.0f

class hiResSensorTelemetryThreadData {
 public:
  // Pointers used inside the thread to communicate to the outside world.
  int threadDone;
  HI_RES_TELEMETRY_STATE hiResTelemetryPublisherState;
  
  // Data passed to the thread on startup.
  float period;
};


class hiResSensorTelemetryThread {
 public:
  hiResSensorTelemetryThread(int nddsDomain, float period);
  ~hiResSensorTelemetryThread();

  void start();
  void stop();
  HI_RES_TELEMETRY_STATE getState();

 private:
  void produceTelemetry();
  pthread_t *telThread;
  int nddsDomain;
};


#endif /* __HI_RES_SENSOR_TELEMETRY_H__ */
