#include <iostream.h>
#include <pthread.h>
#include "ndds/NDDS.h"
#include "hiResSensorTelemetryThread.h"
#include "nddsMsgNames.h"

// The actual telemetry data structure.
hiResDerivedState hiResDerived;
hiResDerivedState *p_hiResDerived = &hiResDerived;

// The telemetry thread data
hiResSensorTelemetryThreadData hiResTelemetryData;

hiResSensorTelemetryThread::hiResSensorTelemetryThread(int nddsDomain, float period) {
  telThread = (pthread_t *)calloc(1, sizeof(pthread_t));
  this->nddsDomain = nddsDomain;
  hiResTelemetryData.period = period;
  hiResTelemetryData.threadDone = 0;
  hiResTelemetryData.hiResTelemetryPublisherState = HI_RES_TELEMETRY_STOP;
  NddsInit(nddsDomain, NULL);
  hiResDerivedStateNddsRegister();
  
}

hiResSensorTelemetryThread::~hiResSensorTelemetryThread() {
  hiResTelemetryData.hiResTelemetryPublisherState = HI_RES_TELEMETRY_STOP;
  while(!hiResTelemetryData.threadDone) {}
}

void hiResSensorTelemetryThread::start() {
  hiResTelemetryData.hiResTelemetryPublisherState = HI_RES_TELEMETRY_START;
  
  if(pthread_create(telThread, NULL, (void *)produceTelemetry, NULL) != 0) {
    cerr << "[hiResSensorTelemetryThread] ERROR: Cannot start thread!" << endl;
    hiResTelemetryData.hiResTelemetryPublisherState = HI_RES_TELEMETRY_STOP;
  } 
}

void hiResSensorTelemetryThread::produceTelemetry() {
  cerr << "[hiResSensorTelemetryThread] Starting up telemetry publisher...";
  NDDSPublication hiResTelemetryPub = NddsPublicationCreate(HI_RES_DERIVED_STATE_MSG_NAME,
							    hiResDerivedStatePublicationType,
							    p_hiResDerived, HI_RES_TELEMETRY_PERSISTANCE,
							    HI_RES_TELEMETRY_STRENGTH);
  hiResTelemetryData.threadDone = 0;

  cerr << "done!!" << endl;

  while(hiResTelemetryData.hiResTelemetryPublisherState == HI_RES_TELEMETRY_START) {
    // TBD: Load up the timeStamp properly!
    NddsPublicationSend(hiResTelemetryPub);
    NddsUtilitySleep(hiResTelemetryData.period);
  }

  cerr << "[hiResSensorTelemetryThread] Exiting thread...";
  hiResTelemetryData.hiResTelemetryPublisherState = HI_RES_TELEMETRY_STOP;
  hiResTelemetryData.threadDone = 1;
  cerr << "done!" << endl;

  pthread_exit(NULL);
}

void hiResSensorTelemetryThread::stop() {
  hiResTelemetryData.hiResTelemetryPublisherState = HI_RES_TELEMETRY_STOP; // This should stop the while() loop in start().
}

HI_RES_TELEMETRY_STATE hiResSensorTelemetryThread::getState() {
  return(hiResTelemetryData.hiResTelemetryPublisherState);
}
