/* FILE:    frameGrabber.cpp
   AUTHOR:  Michael Wagner
   CREATED: Apr 9, 1999

   DESCRIPTION: Implements the frameGrabber class, encapsulates the 
     functionality of the PXC-200/L framegrabber.
*/

#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include "frameGrabber.h"
#include "hiResSensorDef.h"
#include "ppmRockSeg.h"

// Public frameGrabberConfig functions
frameGrabberConfig::frameGrabberConfig(int sleepTime, int brightness, int contrast, int hue, int satU, int satV) {
  if(sleepTime > 0) {
    this->sleepTime = sleepTime; 
  } else {
    this->sleepTime = PXC_DEFAULT_SLEEP_TIME;
  }
  this->brightness = brightness;
  this->contrast = contrast;
  this->hue = hue;
  this->satU = satU;
  this->satV = satV;
}

int frameGrabberConfig::getSleepTime() {
  return(this->sleepTime);
}

int frameGrabberConfig::getBrightness() {
  return(this->brightness);
}

int frameGrabberConfig::getContrast() {
  return(this->contrast);
}

int frameGrabberConfig::getHue() {
  return(this->hue);
}

int frameGrabberConfig::getSatU() {
  return(this->satU);
}

int frameGrabberConfig::getSatV() {
  return(this->satV);
}

void frameGrabberConfig::setSleepTime(int sleepTime) {
  this->sleepTime = sleepTime;
}

void frameGrabberConfig::setBrightness(int brightness) {
  this->brightness = brightness;
}

void frameGrabberConfig::setContrast(int contrast) {
  this->contrast = contrast;
}

void frameGrabberConfig::setHue(int hue) {
  this->hue = hue;
}

void frameGrabberConfig::setSatU(int satU) {
  this->satU = satU;
}

void frameGrabberConfig::setSatV(int satV) {
  this->satV = satV;
}



// Public frameGrabber functions. 

frameGrabber::frameGrabber(frameGrabberConfig *config) {
  this->config = config;

  cerr << "[frameGrabber] PXC driver location is " << PXC_DRV_LOCATION << endl;
  cerr << "[frameGrabber] PXC tmp PPM file is " << PXC_TMP_PPM_FILE << endl;
  cerr << "[frameGrabber] PXC tmp PGM file is " << PXC_TMP_PGM_FILE << endl;
  
#ifdef ACQ_IMAGE
  cerr << "[frameGrabber] The image \"" << PXC_HI_RES_PPM_DEV << "\" is being used in place of high-res PPM device" << endl;
#endif
}

void frameGrabber::setConfig(frameGrabberConfig *config) {
  this->config = config;
}

frameGrabberConfig *frameGrabber::getConfig() {
  return(this->config);
}


// File-based framegrabber functions. These return filenames.

char *frameGrabber::captureHiResPPM(int channel) {
  char *buf = new char[PXC_CMD_BUFF_LENGTH];

  /*
  // TBD: This code does not work. Use ioctl's instead!
  // Keep the device open.
  sprintf(buf, "sleep %d < %s", this->config->getSleepTime(), PXC_HI_RES_PPM_DEV);
  system(buf);
  // Set config.
  sprintf(buf, "%s/pxc_control %s setbright %d 2> /dev/null", PXC_DRV_LOCATION, PXC_HI_RES_PPM_DEV, this->config->getBrightness());
  system(buf);
  sprintf(buf, "%s/pxc_control %s setcontrast %d 2> /dev/null", PXC_DRV_LOCATION, PXC_HI_RES_PPM_DEV, this->config->getContrast());
  system(buf);
  sprintf(buf, "%s/pxc_control %s sethue %d 2> /dev/null", PXC_DRV_LOCATION, PXC_HI_RES_PPM_DEV, this->config->getHue());
  system(buf);
  sprintf(buf, "%s/pxc_control %s setsatu %d 2> /dev/null", PXC_DRV_LOCATION, PXC_HI_RES_PPM_DEV, this->config->getSatU());
  system(buf);
  sprintf(buf, "%s/pxc_control %s setsatv %d 2> /dev/null", PXC_DRV_LOCATION, PXC_HI_RES_PPM_DEV, this->config->getSatV());
  system(buf);
  */
  /*
  ppmRockSeg image;

  long args[1];
  FILE *f = fopen(PXC_CTL_DEV, "r+");
  args[0] = 0x17; //this->config->getBrightness();
  ioctl(fileno(f), PX_IOCSBRIGHT, args);

  args[0] = 0;
  ioctl(fileno(f), PX_IOCGBRIGHT, args);
  cerr << args[0] << " =?= " << 0x17 << endl;

  args[0] = this->config->getContrast();
  ioctl(fileno(f), PX_IOCSCONTRAST, args);
  args[0] = this->config->getHue();
  ioctl(fileno(f), PX_IOCSHUE, args);
  args[0] = this->config->getSatU();
  ioctl(fileno(f), PX_IOCSSATU, args);
  args[0] = this->config->getSatV();
  ioctl(fileno(f), PX_IOCSSATV, args);
  fclose(f);
*/

  long args[1];
  args[0] = channel;
  FILE *f = fopen(PXC_HI_RES_PPM_DEV, "r+");
  ioctl(fileno(f), PX_IOCSMUX, args);

  // Copy out the image.
  sprintf(buf, "cp %s %s", PXC_HI_RES_PPM_DEV, PXC_TMP_PPM_FILE);
  system(buf);
  delete(buf);

  fclose(f);
  
  return(PXC_TMP_PPM_FILE);
}

char *frameGrabber::captureLowResPPM(int channel) {
  char *buf = new char[PXC_CMD_BUFF_LENGTH];

  /*
  // TBD: This code does not work. Use ioctl's instead!
  // Keep the device open.
  sprintf(buf, "sleep %d < %s", this->config->getSleepTime(), PXC_HI_RES_PPM_DEV);
  system(buf);
  // Set config.
  sprintf(buf, "%s/pxc_control %s setbright %d 2> /dev/null", PXC_DRV_LOCATION, PXC_HI_RES_PPM_DEV, this->config->getBrightness());
  system(buf);
  sprintf(buf, "%s/pxc_control %s setcontrast %d 2> /dev/null", PXC_DRV_LOCATION, PXC_HI_RES_PPM_DEV, this->config->getContrast());
  system(buf);
  sprintf(buf, "%s/pxc_control %s sethue %d 2> /dev/null", PXC_DRV_LOCATION, PXC_HI_RES_PPM_DEV, this->config->getHue());
  system(buf);
  sprintf(buf, "%s/pxc_control %s setsatu %d 2> /dev/null", PXC_DRV_LOCATION, PXC_HI_RES_PPM_DEV, this->config->getSatU());
  system(buf);
  sprintf(buf, "%s/pxc_control %s setsatv %d 2> /dev/null", PXC_DRV_LOCATION, PXC_HI_RES_PPM_DEV, this->config->getSatV());
  system(buf);
  */
  /*
  ppmRockSeg image;

  long args[1];
  FILE *f = fopen(PXC_CTL_DEV, "r+");
  args[0] = 0x17; //this->config->getBrightness();
  ioctl(fileno(f), PX_IOCSBRIGHT, args);

  args[0] = 0;
  ioctl(fileno(f), PX_IOCGBRIGHT, args);
  cerr << args[0] << " =?= " << 0x17 << endl;

  args[0] = this->config->getContrast();
  ioctl(fileno(f), PX_IOCSCONTRAST, args);
  args[0] = this->config->getHue();
  ioctl(fileno(f), PX_IOCSHUE, args);
  args[0] = this->config->getSatU();
  ioctl(fileno(f), PX_IOCSSATU, args);
  args[0] = this->config->getSatV();
  ioctl(fileno(f), PX_IOCSSATV, args);
  fclose(f);
*/

  long args[1];
  args[0] = channel;
  FILE *f = fopen(PXC_LOW_RES_PPM_DEV, "r+");
  ioctl(fileno(f), PX_IOCSMUX, args);

  // Copy out the image.
  sprintf(buf, "cp %s %s", PXC_LOW_RES_PPM_DEV, PXC_TMP_PPM_FILE);
  system(buf);
  delete(buf);

  fclose(f);
  
  return(PXC_TMP_PPM_FILE);
}

char *frameGrabber::captureHiResPGM(int channel) {
  char *buf = new char[PXC_CMD_BUFF_LENGTH];

  /*
  // TBD: This code does not work. Use ioctl's instead!
  // Keep the device open.
  sprintf(buf, "sleep %d < %s", this->config->getSleepTime(), PXC_HI_RES_PPM_DEV);
  system(buf);
  // Set config.
  sprintf(buf, "%s/pxc_control %s setbright %d 2> /dev/null", PXC_DRV_LOCATION, PXC_HI_RES_PPM_DEV, this->config->getBrightness());
  system(buf);
  sprintf(buf, "%s/pxc_control %s setcontrast %d 2> /dev/null", PXC_DRV_LOCATION, PXC_HI_RES_PPM_DEV, this->config->getContrast());
  system(buf);
  sprintf(buf, "%s/pxc_control %s sethue %d 2> /dev/null", PXC_DRV_LOCATION, PXC_HI_RES_PPM_DEV, this->config->getHue());
  system(buf);
  sprintf(buf, "%s/pxc_control %s setsatu %d 2> /dev/null", PXC_DRV_LOCATION, PXC_HI_RES_PPM_DEV, this->config->getSatU());
  system(buf);
  sprintf(buf, "%s/pxc_control %s setsatv %d 2> /dev/null", PXC_DRV_LOCATION, PXC_HI_RES_PPM_DEV, this->config->getSatV());
  system(buf);
  */
  /*
  ppmRockSeg image;

  long args[1];
  FILE *f = fopen(PXC_CTL_DEV, "r+");
  args[0] = 0x17; //this->config->getBrightness();
  ioctl(fileno(f), PX_IOCSBRIGHT, args);

  args[0] = 0;
  ioctl(fileno(f), PX_IOCGBRIGHT, args);
  cerr << args[0] << " =?= " << 0x17 << endl;

  args[0] = this->config->getContrast();
  ioctl(fileno(f), PX_IOCSCONTRAST, args);
  args[0] = this->config->getHue();
  ioctl(fileno(f), PX_IOCSHUE, args);
  args[0] = this->config->getSatU();
  ioctl(fileno(f), PX_IOCSSATU, args);
  args[0] = this->config->getSatV();
  ioctl(fileno(f), PX_IOCSSATV, args);
  fclose(f);
*/

  long args[1];
  args[0] = channel;
  FILE *f = fopen(PXC_HI_RES_PGM_DEV, "r+");
  ioctl(fileno(f), PX_IOCSMUX, args);

  // Copy out the image.
  sprintf(buf, "cp %s %s", PXC_HI_RES_PGM_DEV, PXC_TMP_PGM_FILE);
  system(buf);
  delete(buf);

  fclose(f);
  
  return(PXC_TMP_PGM_FILE);
}

char *frameGrabber::captureLowResPGM(int channel) {
  char *buf = new char[PXC_CMD_BUFF_LENGTH];

  /*
  // TBD: This code does not work. Use ioctl's instead!
  // Keep the device open.
  sprintf(buf, "sleep %d < %s", this->config->getSleepTime(), PXC_HI_RES_PPM_DEV);
  system(buf);
  // Set config.
  sprintf(buf, "%s/pxc_control %s setbright %d 2> /dev/null", PXC_DRV_LOCATION, PXC_HI_RES_PPM_DEV, this->config->getBrightness());
  system(buf);
  sprintf(buf, "%s/pxc_control %s setcontrast %d 2> /dev/null", PXC_DRV_LOCATION, PXC_HI_RES_PPM_DEV, this->config->getContrast());
  system(buf);
  sprintf(buf, "%s/pxc_control %s sethue %d 2> /dev/null", PXC_DRV_LOCATION, PXC_HI_RES_PPM_DEV, this->config->getHue());
  system(buf);
  sprintf(buf, "%s/pxc_control %s setsatu %d 2> /dev/null", PXC_DRV_LOCATION, PXC_HI_RES_PPM_DEV, this->config->getSatU());
  system(buf);
  sprintf(buf, "%s/pxc_control %s setsatv %d 2> /dev/null", PXC_DRV_LOCATION, PXC_HI_RES_PPM_DEV, this->config->getSatV());
  system(buf);
  */
  /*
  ppmRockSeg image;

  long args[1];
  FILE *f = fopen(PXC_CTL_DEV, "r+");
  args[0] = 0x17; //this->config->getBrightness();
  ioctl(fileno(f), PX_IOCSBRIGHT, args);

  args[0] = 0;
  ioctl(fileno(f), PX_IOCGBRIGHT, args);
  cerr << args[0] << " =?= " << 0x17 << endl;

  args[0] = this->config->getContrast();
  ioctl(fileno(f), PX_IOCSCONTRAST, args);
  args[0] = this->config->getHue();
  ioctl(fileno(f), PX_IOCSHUE, args);
  args[0] = this->config->getSatU();
  ioctl(fileno(f), PX_IOCSSATU, args);
  args[0] = this->config->getSatV();
  ioctl(fileno(f), PX_IOCSSATV, args);
  fclose(f);
*/

  long args[1];
  args[0] = channel;
  FILE *f = fopen(PXC_LOW_RES_PGM_DEV, "r+");
  ioctl(fileno(f), PX_IOCSMUX, args);

  // Copy out the image.
  sprintf(buf, "cp %s %s", PXC_LOW_RES_PGM_DEV, PXC_TMP_PGM_FILE);
  system(buf);
  delete(buf);

  fclose(f);
  
  return(PXC_TMP_PGM_FILE);
}


// Memory-based framegrabber functions. They return pointers to the image in memory, NULL on failure.

unsigned char *frameGrabber::hiResRGB(int channel) {
  return(getImage(PXC_HI_RES_RGB_DEV, PXC_HI_RES_IMAGE_ROWS, PXC_HI_RES_IMAGE_COLS, PXC_RGB_IMAGE_BYTES, channel));
}

unsigned char *frameGrabber::lowResRGB(int channel) {
  return(getImage(PXC_LOW_RES_RGB_DEV, PXC_LOW_RES_IMAGE_ROWS, PXC_LOW_RES_IMAGE_COLS, PXC_RGB_IMAGE_BYTES, channel));
}

unsigned char *frameGrabber::hiResMono(int channel) {
  return(getImage(PXC_HI_RES_MONO_DEV, PXC_HI_RES_IMAGE_ROWS, PXC_HI_RES_IMAGE_COLS, PXC_MONO_IMAGE_BYTES, channel));
}

int frameGrabber::lowResMono(unsigned char *image, int channel) {
  return(getImage(image, PXC_LOW_RES_MONO_DEV, PXC_LOW_RES_IMAGE_ROWS, PXC_LOW_RES_IMAGE_COLS, PXC_MONO_IMAGE_BYTES, channel));
}

unsigned char *frameGrabber::getImage(const char *device, int numRows, int numCols, int numColorBytes, int channel) {
  FILE *fp;
  int fd;
  unsigned char *addr;
  unsigned long arg=0;

  if(!(fp=fopen(device, "r"))) {
    cerr << "[frameGrabber] ERROR: Cannot open " << device << "!" << endl;
  }

  fd=fileno(fp);

  int size = numColorBytes * numRows * numCols;

  arg = channel;
  ioctl(fd, PX_IOCSMUX, &arg);

  addr=(unsigned char *)mmap(0, (size_t)size, PROT_READ, MAP_FILE | MAP_PRIVATE, fd, (off_t)0);
  if(addr == NULL) {
    cerr << "[frameGrabber] ERROR: Cannot map " << device << " to memory!" << endl;
    return(NULL);
  }

  ioctl(fd, PX_IOCWAITVB, &arg);

  unsigned char *retVal = new unsigned char[size];;
  memcpy(retVal, addr, (size_t)(size));

  if(munmap(0, size) < 0) {
    cerr << "[frameGrabber] ERROR: Cannot unmap device from memory!" << endl;
  }
  
  fclose(fp);
  return(retVal);
}

int frameGrabber::getImage(unsigned char *image, const char *device, int numRows, int numCols, int numColorBytes, int channel) {
  FILE *fp;
  int fd;
  unsigned char *addr;
  unsigned long arg=0;

  if(!(fp=fopen(device, "r"))) {
    cerr << "[frameGrabber] ERROR: Cannot open " << device << "!" << endl;
  }

  fd=fileno(fp);

  int size = numColorBytes * numRows * numCols;

  arg = channel;
  ioctl(fd, PX_IOCSMUX, &arg);

  addr=(unsigned char *)mmap(0, (size_t)size, PROT_READ, MAP_FILE | MAP_PRIVATE, fd, (off_t)0);
  if(addr == NULL) {
    cerr << "[frameGrabber] ERROR: Cannot map " << device << " to memory!" << endl;
    return(0);
  }

  ioctl(fd, PX_IOCWAITVB, &arg);

  memcpy(image, addr, (size_t)(size));

  if(munmap(addr, size) < 0) {
    cerr << "[frameGrabber] ERROR: Cannot unmap device from memory!" << endl;
  }
  
  fclose(fp);
  return(1);
}




