#ifndef __SPECTROMETER_DEF_H__
#define __SPECTROMETER_DEF_H__

#define SPEC_MAX_SAMPLES_UNTIL_WHITE_CALIBRATION 4
#define SPEC_MAX_SAMPLES_UNTIL_DARK_CALIBRATION 40

#define SPEC_NUM_PIXELS 2048
#define SPEC_NUM_CHANNELS 4
#define SPEC_ACTIVE_CHANNEL 0
#define SPEC_SATURATION 3967      /* Detector saturated */
#define SPEC_MAX_WAVELENGTH 1100  /* nm */
#define SPEC_MIN_WAVELENGTH 300   /* nm */
#define SPEC_MIN_INTEGRATION_TIME 5 /* msec */
#define SPEC_MAX_INTEGRATION_TIME 100 /* msec */
#define SPEC_MAX_REFLECTANCE 10.0
#define SPEC_MIN_REFLECTANCE -1.0
#define SPEC_MIN_SAT_CHANNELS 20  /* minimums for a spectrum to be considered saturated */
#define SPEC_MIN_ADJ_SAT_CHANNELS 5

#define SPEC_DEVICE "/dev/adc500"
#define SPEC_STATUS_DEVICE "/dev/adc500_status"

typedef enum {
  SPEC_OK,
  SPEC_NO_WHITE_REF,
  SPEC_NO_DARK_REF,
  SPEC_SATURATED,
  SPEC_UNSTABLE,
  SPEC_TIMEOUT,
  SPEC_FAILED,
  SPEC_NOT_INITIALIZED,
  SPEC_CALIBRATED,
  SPEC_COULD_NOT_OPTIMIZE
} SPEC_STATUS;

#endif /* __SPECTROMETER_DEF_H__ */

