#!/usr/bin/wish8.0
load /usr/local/lib/libBLT.so.2.4
load /usr/local/lib/s2000.so
namespace import blt::*

set SPEC_MIN_WAVELENGTH 300.0
set SPEC_MAX_WAVELENGTH 1100.0
set SPEC_NUM_PIXELS 2048

set spectro [open /dev/adc500 r+] 
fconfigure $spectro -blocking 0 -translation binary -buffering none

vector Y Ytmp X XNM TMP CALIB(2048)
set CALIB(0:2047) .0001 
TMP set { 0 2047 }
TMP populate X 2046 
vector reflectance([expr int($SPEC_MAX_WAVELENGTH) - int($SPEC_MIN_WAVELENGTH) + 1])
vector reflectanceX([expr int($SPEC_MAX_WAVELENGTH) - int($SPEC_MIN_WAVELENGTH) + 1])

# calculate pixel to nanometers
# please insert the correct values for your spectrometer
proc calcXNM { } {
    global SPEC_MAX_WAVELENGTH SPEC_MIN_WAVELENGTH SPEC_NUM_PIXELS
    XNM set [X + 0]
    XNM set [XNM * [expr (($SPEC_MAX_WAVELENGTH - $SPEC_MIN_WAVELENGTH) / ($SPEC_NUM_PIXELS - 1.0))]]
    XNM set [XNM + $SPEC_MIN_WAVELENGTH];
}
calcXNM

puts "Wavelength range is $XNM(0) $XNM(end)"

button .exit -text Exit -command { exit 0 }
button .start -text Start -state disabled -command {
    .graph element delete line
    .graph element create line -xdata XNM -ydata Y -symbol none
    .graph yaxis configure -min 0 -max $yaxisMax
    .graph xaxis configure -min "" -max ""  -title "nm"
    .graph configure -title "Raw Spectrum" 
    .start configure -state disabled
    .stop configure -state normal
    .yaxisScale configure -state normal
}
button .darkRef -text "Dark Reference" -command {
    puts "Taking dark reference..."
    set retVal [doDarkRef]
    if {$retVal == "0"} {
	puts "Done!"
    } else {
	puts "Error reading dark spectrum! Returned $retVal" 
    }
}
button .whiteRef -text "White Reference" -command {
    puts "Taking white reference..."
    set retVal [doWhiteRef]
    if {$retVal == "0"} {
	puts "Done!"
    } else {
	puts "Error reading white spectrum! Returned $retVal" 
    }
}
button .sample -text "Take Sample" -command {
    puts "Taking sample spectrum..."
    set retVal [doSampleSpectrum "test.spec"]
    if {$retVal == "0"} {
	set fileId [open test.spec r]
        set tmpLine ""
	set tmpSig ""
	set tmpWave ""
	for {set i 0} {$i <= [expr int($SPEC_MAX_WAVELENGTH) - int($SPEC_MIN_WAVELENGTH)]} {incr i} {
	    gets $fileId tmpLine
	    set tmpWave [string range $tmpLine 0 [string wordend $tmpLine 0]]
	    set tmpSig [string range $tmpLine [string wordend $tmpLine 0] [string length $tmpLine]]
	    set reflectanceX($i) $tmpWave
	    set reflectance($i) $tmpSig
	}
	close $fileId

	Ytmp set Y
	.graph element delete line
	.graph element create line -xdata reflectanceX -ydata reflectance -symbol none
	.graph yaxis configure -min "" -max ""
	.graph xaxis configure -min "" -max ""
	.graph configure -title "Sample Reflection Spectrum"
	.start configure -state normal
	.stop configure -state disabled
	.yaxisScale configure -state disabled
	puts "Done! Hit 'Start' to return to raw spectrum"
    } elseif {$retVal == "1"} {
	puts "Error reading sample spectrum! White reference needed!"
    } elseif {$retVal == "2"} {
	puts "Error reading sample spectrum! Dark reference needed!"
    } else {
	puts "Error reading sample spectrum! Returned $retVal"
    }
}

button .stop -text Stop -command { 
    Ytmp set Y
    .graph element delete line
    .graph element create line -xdata XNM -ydata Ytmp -symbol none
    .start configure -state normal
    .stop configure -state disabled
}

set yaxisMax 0.50

graph .graph -width 500 -height 200 -title "Raw Spectrum" 
.graph yaxis configure -min 0 -max $yaxisMax
.graph xaxis configure  -title "nm"
.graph element create line -xdata XNM -ydata Y -symbol none

scale .yaxisScale -from 0.01 -to 2 -variable yaxisMax -resolution 0.01 -digits 3 \
	-orient horizontal -label "y-Axis Scale" -tickinterval 0 -showvalue true
bind .yaxisScale <ButtonRelease-1> {
    .graph yaxis configure -min 0 -max $yaxisMax
}

pack .graph .yaxisScale .darkRef .whiteRef .sample .start .stop .exit -expand true -fill both

# connect vector Y to the spectrometer
# multiply the spectrometer data with vector CALIB 
# before writing them to vector Y ( for sensivity calibration ) 

s2000_link_vector $spectro Y CALIB
