#ifndef __SPECTROMETER_H__
#define __SPECTROMETER_H__

#include <fstream.h>
#include "spectrometerDef.h"

/* abs for floats doesn't exist so here it is */
#ifndef FLOAT_ABS
#define FLOAT_ABS
//float abs(float x) {
//  if(x >= 0.0) 
//    return(x);
//  else
//    return(-x);
//}
#endif /* FLOAT_ABS */

class spectrometer {
 public:
  // Public spectrometer variables
  int numSamplesAvg; // Number of samples to average
  float tolerance;  // Maximum allowed input variation

  spectrometer();
  ~spectrometer();

  void init();
  int uninit();

  // Spectrometer action methods
  int doWhiteRef();                // All these return a SPEC_STATUS  
  int doRawSpectrum();             // (from spectrometerDef.h)
  int doDarkRef();
  int doSampleSpectrum(char *filename);
  int writeSpectrum(float *spectrum, char *filename);

  int isCalibrated(); // Returns 1 or 0

  void displayStatus(); // Will dump status to screen

  int setIntegrationTime(int time); // Set time in ms, returns SPEC_STATUS

 private:
  fstream inSpecStream, outSpecStream, specStatusStream;
  int status; // Equal to a SPEC_STATUS

  // Private spectrometer variables
  float dispersion; // TBD: units?
  float offset;     // TBD: units?
  int flashDelay;   // TBD: units?
  int samplingFreq; // TBD: Units? ms????
  int correctDark;

  // The arrays for various spectral reference and sample readings
  float darkRef[SPEC_NUM_PIXELS];
  float whiteRef[SPEC_NUM_PIXELS];
  float rawSpectrum[SPEC_NUM_PIXELS];
  float previousSpectrum[SPEC_NUM_PIXELS];
  float reflectanceSpectrum[SPEC_NUM_PIXELS];
  
  int darkRefExists;
  int whiteRefExists;
  int rawSpectrumExists;
  int previousSpectrumExists;

  int samplesSinceDarkRef;
  int samplesSinceWhiteRef;

  // Private spectrum manipulation methods
  int doSpectrum(float *spectrum); // Returns a SPEC_STATUS  
  int isSaturated(float *spectrum); // Returns 1 or 0
  void calcReflectance();
  void correctSpectrum(float *spectrum);
  int isValidInput(float *spectrum); // Returns SPEC_STATUS
  int getIndex(int wavelength); // Calculates spectrum index from wavelength
  int optimizeIntegrationTime();  // Returns SPEC_STATUS
  int setNumAddedFrames(int num);
  int selectChannel(int channel);
  int sendCommand(char *cmd); // Returns SPEC_STATUS
};

#endif /* __SPECTROMETER_H__ */
