#ifndef __R3VECTOR
#define __R3VECTOR
#include <math.h>
#include <iostream.h>
#define SQ(a) ((a)*(a))

typedef struct CYLIND_COORDS {
  double r;
  double z;
  double theta;
} cylindricalCoord;


class r3Vector {
  double v[3];
  
public:
  r3Vector(double p0,double p1, double p2);
  r3Vector(void) {v[0]=0;v[1]=0;v[2]=0;};
  double length(void);
  void normalize(void);
  void rotate(double roll, double pitch, double yaw);
  friend ostream &operator<<(ostream &str, r3Vector &v);  
  friend istream &operator>>(istream &stream, r3Vector &in);
  r3Vector & operator +=(const r3Vector& rhs);
  r3Vector & operator -=(const r3Vector& rhs);
  double& operator[](int i);
  const double& operator[](int i) const;
  double  dot(r3Vector& on);
  double distanceTo(r3Vector & b) { return sqrt(SQ(v[0]-b[0]) + SQ(v[1]-b[1]) + SQ(v[2]-b[2]));};
  

  cylindricalCoord toCylindrical(double Ox,double Oy,double Oz);
  cylindricalCoord toCylindrical(r3Vector O) {return toCylindrical(O[0],O[1],O[2]);};
  void setFromCylindrical(double Ox,double Oy,double Oz, cylindricalCoord c);
  void setFromCylindrical(r3Vector O, cylindricalCoord c) {setFromCylindrical(O[0],O[1],O[2],c);};

  r3Vector& operator=(const r3Vector rhs);

 };

r3Vector operator +(const r3Vector& rhs);
r3Vector operator -(const r3Vector& rhs);


r3Vector operator+(const r3Vector & a, const r3Vector & b);
r3Vector operator-(const r3Vector & a, const r3Vector & b);
r3Vector operator*(const double a, const r3Vector &b);
r3Vector operator*(const r3Vector & a, const double &b);



class InvalidIndexException {
  //an invalid index was passed to the r3Vector
};


#endif __R3VECTOR





