#include "r3Line.h"

void r3Line::from2Pts(r3Vector &p,r3Vector& q) {
  a=p;
  m= p-q;
}

void r3Line::fromPtSlope(r3Vector& p, r3Vector& slope) {
  a=p;
  m=slope;
}

int r3Line::parallelTo(r3Line& b) {
  r3Vector N, bN;
  N = m;
  N.normalize();
  bN = b.m;
  bN.normalize();
    
  if (N[0] == bN[0] && N[1] ==bN[1] && N[2] ==bN[2]) {
    return 1;
  }
  if (N[0] == -bN[0] && N[1] ==-bN[1] && N[2] ==-bN[2]) {
    return 1;
  }
  return 0;
}


r3Vector r3Line::centerTo(r3Line& b) {
  r3Vector p1,p2,q1,q2;
  r3Vector P,Q,mid;
  r3Vector AMinusC;
  double numerator, bottom;
  double t1,t2;

  
  if (parallelTo(b)) {
    cerr << "code can't deal with parallel lines...\n";
    cerr << "r3Line.cpp - centerTo\n";
    mid[0]=0;
    mid[1]=0;
    mid[2]=0;
    return mid;
  }
  AMinusC = a-b.a;
  numerator =AMinusC.dot(b.m);
  numerator = numerator + (m.dot(b.m)*AMinusC.dot(m))/m.dot(m);
  bottom = m.dot(b.m)*m.dot(b.m)/(m.dot(m));
  bottom = bottom - b.m.dot(b.m);

  t2 = numerator/bottom;
  t1 = (-AMinusC.dot(m) + m.dot(b.m)*t2)/(m.dot(m));
  
  p1 = (m*t1)+a;
  q1 = (b.m*t2)+b.a;
  
  p2 = (m*(-t1))+a;
  q2 = (b.m*(-t2))+b.a;
  
  if (p1.distanceTo(q1) < p2.distanceTo(q2)) {
    cerr << "end points of sement are " << p1 << q1 << "\n";
    mid = (p1+q1)*0.5;
  } else {
    cerr << "end points of segment are " << p2 << q2 << "\n";
    mid = (p2+q2)*0.5;
  }

  return mid;
    

}



/*
void main(void) {
  r3Vector a1,a2,b1,b2;
  r3Line A,B;
  a1[0]=1;
  b1[0]=1;
  b1[2]=1;
  b2[1]=1;
  A.from2Pts(a1,b1);
  B.from2Pts(a2,b2);
  cout << "center is " << A.centerTo(B) << "\n";


  }*/
