#ifndef __METAL_DETECTOR_H__
#define __METAL_DETECTOR_H__

#include "daqCard.h"
#include "metalDetectorDef.h"

class metalDetector {
 public:
  void init();
  
  // These return METAL_STATUS
  int getReference();
  int getSignal();
  int writeAllData(char *filename); /* Writes as much data as it can into three files:
				         1) "filename.reference": If the reference reading exists, write it here
				         2) "filename.signal": If the signal reading exists, write it here
				         3) "filename": There are two lines in this file:
					                      "filename.reference"
							      "filename.signal"
							If either do not exist, a "NULL" will hold its place
				    */

 private:
  // These return METAL_STATUS
  int getReading(float *buffer, int length);
  int writeFile(char *filename, float *buffer, int length);

  daqCard daq;
  float reference[METAL_NUM_READINGS];
  int referenceExists;
  float signal[METAL_NUM_READINGS];
  int signalExists;
  float daqPeriod; // The time between readings in seconds
};

#endif /* __METAL_DETECTOR_H__ */

  



