#include <iostream.h>
#include <fstream.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include "metalDetector.h"
#include "metalDetectorDef.h"
#include "daqCard.h"
#include "SAS_Config.h"

// Public functions

void metalDetector::init() {
  if(daq.open() == DAQ_CARD_OK) {
    if(daq.setChannel(METAL_DAQ_CHANNEL)) {
      cerr << "[metalDetector] Successfully started metal detector!" << endl;
    } else {
      cerr << "[metalDetector] ERROR: Could not start metal detector!" << endl;
    }
  } else {
    cerr << "[metalDetector] ERROR: Metal detector could not be initialized!" << endl;
  }

  referenceExists = signalExists = 0;
}

int metalDetector::getReference() {
  int results = getReading(reference, METAL_NUM_READINGS);
  if(results == METAL_OK) {
    referenceExists = 1;
  } 
  return(results);
}

int metalDetector::getSignal() {
  int results = getReading(signal, METAL_NUM_READINGS);
  if(results == METAL_OK) {
    signalExists = 1;
  } 
  return(results);
}

int metalDetector::writeAllData(char *filename) {
  char *referenceFileName, *signalFileName;
  referenceFileName = new char[strlen(filename) + strlen(".reference") + 1];
  signalFileName = new char[strlen(filename) + strlen(".signal") + 1];

  sprintf(referenceFileName, "%s.reference", filename);
  sprintf(signalFileName, "%s.signal", filename);

  fstream outFile(filename, ios::out);
  if(outFile.fail()) {
    return(METAL_FAILED);
  }

  if(referenceExists) {
    if(writeFile(referenceFileName, reference, METAL_NUM_READINGS) == METAL_OK) {
      outFile << referenceFileName << endl;
    } else {
      outFile << "NULL" << endl;
    }
  } else {
    outFile << "NULL" << endl;
  }
  if(signalExists) {
    if(writeFile(signalFileName, signal, METAL_NUM_READINGS) == METAL_OK) {
      outFile << signalFileName << endl;
    } else {
      outFile << "NULL" << endl;
    }
  } else {
    outFile << "NULL" << endl;
  }

  outFile.close();
  return(METAL_OK);
}


// Private methods

int metalDetector::getReading(float *buffer, int length) {
  int retVal;
  float readingTimeBuffer[METAL_NUM_READINGS]; // daq.read returns the relative reading times here...could be used for debug

  retVal = daq.read(buffer, METAL_NUM_READINGS, METAL_READING_PERIOD, readingTimeBuffer);
  if(retVal == DAQ_CARD_OK) {
    return(METAL_OK);
  } else {
    return(METAL_FAILED);
  }
}


int metalDetector::writeFile(char *filename, float *dataBuff, int length) {
  if(dataBuff == NULL || filename == NULL) {
    return(METAL_FAILED);
  }

  fstream outfile;
  outfile.open(filename, ios::out);

  if(outfile.fail()) {
    cerr << "[metalDetector] ERROR: Cannot open " << filename << " for writing!" << endl;
    return(METAL_FAILED);
  }
  
  for(int i=0; i < length; i++) {
    outfile << dataBuff[i] << endl;
  }

  outfile.close();

  return(METAL_OK);
}

