#ifndef __ARM_SENSOR_TELEMETRY_H__
#define __ARM_SENSOR_TELEMETRY_H__

#include <pthread.h>
#include "telemetryMsgs.h"

typedef enum {
  ARM_TELEMETRY_START,
  ARM_TELEMETRY_STOP
} ARM_TELEMETRY_STATE;

#define ARM_TELEMETRY_DEFAULT_PERIOD 2.0f /* sec */
#define ARM_TELEMETRY_PERSISTANCE 15.0f
#define ARM_TELEMETRY_STRENGTH 10.0f

class armSensorTelemetryThreadData {
 public:
  // Pointers used inside the thread to communicate to the outside world.
  int threadDone;
  ARM_TELEMETRY_STATE armTelemetryPublisherState;
  
  // Data passed to the thread on startup.
  float period;
};


class armSensorTelemetryThread {
 public:
  armSensorTelemetryThread(int nddsDomain, float period);
  ~armSensorTelemetryThread();

  void start();
  void stop();
  ARM_TELEMETRY_STATE getState();

 private:
  void produceTelemetry();
  pthread_t *telThread;
  int nddsDomain;
};


#endif /* __ARM_SENSOR_TELEMETRY_H__ */
