#include <iostream.h>
#include <pthread.h>
#include "ndds/NDDS.h"
#include "armSensorTelemetryThread.h"
#include "nddsMsgNames.h"

// The actual telemetry data structure.
armDerivedState armDerived;
armDerivedState *p_armDerived = &armDerived;

// The telemetry thread data
armSensorTelemetryThreadData armTelemetryData;

armSensorTelemetryThread::armSensorTelemetryThread(int nddsDomain, float period) {
  telThread = (pthread_t *)calloc(1, sizeof(pthread_t));
  this->nddsDomain = nddsDomain;
  armTelemetryData.period = period;
  armTelemetryData.threadDone = 0;
  armTelemetryData.armTelemetryPublisherState = ARM_TELEMETRY_STOP;
  NddsInit(nddsDomain, NULL);
  armDerivedStateNddsRegister();
  
}

armSensorTelemetryThread::~armSensorTelemetryThread() {
  armTelemetryData.armTelemetryPublisherState = ARM_TELEMETRY_STOP;
  while(!armTelemetryData.threadDone) {}
}

void armSensorTelemetryThread::start() {
  armTelemetryData.armTelemetryPublisherState = ARM_TELEMETRY_START;
  
  if(pthread_create(telThread, NULL, (void *)produceTelemetry, NULL) != 0) {
    cerr << "[armSensorTelemetryThread] ERROR: Cannot start thread!" << endl;
    armTelemetryData.armTelemetryPublisherState = ARM_TELEMETRY_STOP;
  } 
}

void armSensorTelemetryThread::produceTelemetry() {
  cerr << "[armSensorTelemetryThread] Starting up telemetry publisher...";
  NDDSPublication armTelemetryPub = NddsPublicationCreate(ARM_DERIVED_STATE_MSG_NAME,
							    armDerivedStatePublicationType,
							    p_armDerived, ARM_TELEMETRY_PERSISTANCE,
							    ARM_TELEMETRY_STRENGTH);
  armTelemetryData.threadDone = 0;

  cerr << "done!!" << endl;

  while(armTelemetryData.armTelemetryPublisherState == ARM_TELEMETRY_START) {
    // TBD: Load up the timeStamp properly!
    NddsPublicationSend(armTelemetryPub);
    NddsUtilitySleep(armTelemetryData.period);
  }

  cerr << "[armSensorTelemetryThread] Exiting thread...";
  armTelemetryData.armTelemetryPublisherState = ARM_TELEMETRY_STOP;
  armTelemetryData.threadDone = 1;
  cerr << "done!" << endl;

  pthread_exit(NULL);
}

void armSensorTelemetryThread::stop() {
  armTelemetryData.armTelemetryPublisherState = ARM_TELEMETRY_STOP; // This should stop the while() loop in start().
}

ARM_TELEMETRY_STATE armSensorTelemetryThread::getState() {
  return(armTelemetryData.armTelemetryPublisherState);
}
