/* FILE: armSensorDef.h
   AUTHOR: Michael Wagner
   CREATED: Aug 19, 1999
   DESCRIPTION: This file holds definitions for manipulator arm
     on the Nomad robot.
*/

#ifndef __ARM_SENSOR_DEF_H__
#define __ARM_SENSOR_DEF_H__

#include "MeteoriteArmController.h"  /* Most of the defines are here */

#ifndef PI
#define PI 3.1415927
#endif

#define ARM_TARGET_HEIGHT 0.02 /* m */

#define PXC_ARM_CHANNEL 2

#define ARM_SENSOR_BASE_TIME_COST 120.0   /* sec TBD: Make these not arbitrary */
#define ARM_SENSOR_BASE_ENERGY_COST 10.0 /* Joules TBD: Make these not arbitrary */
#define ARM_SENSOR_BASE_STORAGE_COST 2000 /* Bytes */

#define ARM_SENSOR_MAX_DISTANCE_TOLERANCE 4.0 /* m */
#define ARM_SENSOR_MIN_DISTANCE_TOLERANCE 3.0 /* m */
#define ARM_SENSOR_ANGULAR_TOLERANCE (PI / 2) /* rad */

typedef enum {
  ARM_SENSOR_OK = 0,
  ARM_SENSOR_FAILED,
  ARM_SENSOR_LOST_TARGET
} ARM_SENSOR_EXTENDED_STATUS;

/* These are extensions to the SENSOR_FUNCTION enumeration, 
   which only maps numbers 0 - 1023. */

#endif /* __ARM_SENSOR_DEF_H__ */
